/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model;

import dan200.computercraft.client.model.turtle.ModelTransformer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_2350;
import net.minecraft.class_4590;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class FabricModelTransformer
extends ModelTransformer
implements RenderContext.QuadTransform {
    public FabricModelTransformer(class_4590 transformation) {
        super(transformation);
    }

    public boolean transform(MutableQuadView quad) {
        class_2350 face;
        Vector3f vec3 = new Vector3f();
        for (int i = 0; i < 4; ++i) {
            quad.copyPos(i, vec3);
            this.transformation.transformPosition(vec3);
            quad.pos(i, vec3);
        }
        if (this.invert) {
            FabricModelTransformer.swapQuads(quad, 0, 3);
            FabricModelTransformer.swapQuads(quad, 1, 2);
        }
        if ((face = quad.nominalFace()) != null) {
            quad.nominalFace(class_2350.method_23225((Matrix4f)this.transformation, (class_2350)face));
        }
        return true;
    }

    private static void swapQuads(MutableQuadView quad, int a, int b) {
        float aX = quad.x(a);
        float aY = quad.y(a);
        float aZ = quad.z(a);
        float aU = quad.u(a);
        float aV = quad.v(a);
        float bX = quad.x(b);
        float bY = quad.y(b);
        float bZ = quad.z(b);
        float bU = quad.u(b);
        float bV = quad.v(b);
        quad.pos(b, aX, aY, aZ).uv(b, aU, aV);
        quad.pos(a, bX, bY, bZ).uv(a, bU, bV);
    }
}

