/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl.network.wired;

import dan200.computercraft.impl.network.wired.WiredNetworkImpl;
import dan200.computercraft.impl.network.wired.WiredNodeImpl;
import java.util.Objects;
import javax.annotation.Nullable;

class NodeSet {
    private NodeSet parent = this;
    private int size = 1;
    @Nullable
    private WiredNetworkImpl network;

    NodeSet() {
    }

    private boolean isRoot() {
        return this.parent == this;
    }

    NodeSet find() {
        NodeSet self = this;
        while (!self.isRoot()) {
            self = self.parent = self.parent.parent;
        }
        return self;
    }

    int size() {
        return this.find().size;
    }

    void addNode(WiredNodeImpl node) {
        if (!this.isRoot()) {
            throw new IllegalStateException("Cannot grow a non-root set.");
        }
        if (node.currentSet != null) {
            throw new IllegalArgumentException("Node is already in a set.");
        }
        node.currentSet = this;
        ++this.size;
    }

    public static NodeSet merge(NodeSet left, NodeSet right) {
        if (!left.isRoot() || !right.isRoot()) {
            throw new IllegalArgumentException("Cannot union a non-root set.");
        }
        if (left == right) {
            throw new IllegalArgumentException("Cannot merge a node into itself.");
        }
        return left.size >= right.size ? NodeSet.mergeInto(left, right) : NodeSet.mergeInto(right, left);
    }

    private static NodeSet mergeInto(NodeSet root, NodeSet child) {
        assert (root.size > child.size);
        child.parent = root;
        root.size += child.size;
        return child;
    }

    void setNetwork(WiredNetworkImpl network) {
        if (!this.isRoot()) {
            throw new IllegalStateException("Set is not the root.");
        }
        if (this.network != null) {
            throw new IllegalStateException("Set already has a network.");
        }
        this.network = network;
    }

    WiredNetworkImpl network() {
        return Objects.requireNonNull(this.find().network);
    }
}

