/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.metrics.basic;

import com.google.common.collect.MapMaker;
import dan200.computercraft.core.metrics.Metric;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.metrics.ComputerMetricsObserver;
import dan200.computercraft.shared.computer.metrics.GlobalMetrics;
import dan200.computercraft.shared.computer.metrics.basic.ComputerMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

public class BasicComputerMetricsObserver
implements ComputerMetricsObserver {
    private final GlobalMetrics owner;
    @GuardedBy(value="this")
    private final List<ComputerMetrics> timings = new ArrayList<ComputerMetrics>();
    @GuardedBy(value="this")
    private final Map<ServerComputer, ComputerMetrics> timingLookup = new MapMaker().weakKeys().makeMap();

    public BasicComputerMetricsObserver(GlobalMetrics owner) {
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.owner.addObserver(this)) {
            return;
        }
        BasicComputerMetricsObserver basicComputerMetricsObserver = this;
        synchronized (basicComputerMetricsObserver) {
            this.timings.clear();
            this.timingLookup.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        if (!this.owner.removeObserver(this)) {
            return false;
        }
        BasicComputerMetricsObserver basicComputerMetricsObserver = this;
        synchronized (basicComputerMetricsObserver) {
            this.timingLookup.clear();
        }
        return true;
    }

    public synchronized List<ComputerMetrics> getSnapshot() {
        ArrayList<ComputerMetrics> timings = new ArrayList<ComputerMetrics>(this.timings.size());
        for (ComputerMetrics timing : this.timings) {
            timings.add(new ComputerMetrics(timing));
        }
        return timings;
    }

    public synchronized List<ComputerMetrics> getTimings() {
        return new ArrayList<ComputerMetrics>(this.timings);
    }

    @GuardedBy(value="this")
    private ComputerMetrics getMetrics(ServerComputer computer) {
        ComputerMetrics existing = this.timingLookup.get(computer);
        if (existing != null) {
            return existing;
        }
        ComputerMetrics metrics = new ComputerMetrics(computer);
        this.timingLookup.put(computer, metrics);
        this.timings.add(metrics);
        return metrics;
    }

    @Override
    public synchronized void observe(ServerComputer computer, Metric.Counter counter) {
        this.getMetrics(computer).observe(counter);
    }

    @Override
    public synchronized void observe(ServerComputer computer, Metric.Event event, long value) {
        this.getMetrics(computer).observe(event, value);
    }
}

