/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNetworkChange;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.Map;

public abstract class WiredModemElement
implements WiredElement {
    private final WiredNode node = ComputerCraftAPI.createWiredNodeForElement(this);
    private final Map<String, IPeripheral> remotePeripherals = new HashMap<String, IPeripheral>();

    @Override
    public WiredNode getNode() {
        return this.node;
    }

    @Override
    public String getSenderID() {
        return "modem";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void networkChanged(WiredNetworkChange change) {
        Map<String, IPeripheral> map = this.remotePeripherals;
        synchronized (map) {
            this.remotePeripherals.keySet().removeAll(change.peripheralsRemoved().keySet());
            for (String string : change.peripheralsRemoved().keySet()) {
                this.detachPeripheral(string);
            }
            for (Map.Entry entry : change.peripheralsAdded().entrySet()) {
                this.attachPeripheral((String)entry.getKey(), (IPeripheral)entry.getValue());
            }
            this.remotePeripherals.putAll(change.peripheralsAdded());
        }
    }

    public Map<String, IPeripheral> getRemotePeripherals() {
        return this.remotePeripherals;
    }

    protected abstract void attachPeripheral(String var1, IPeripheral var2);

    protected abstract void detachPeripheral(String var1);
}

