/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.impl.TurtleRefuelHandlers;
import java.util.OptionalInt;
import net.minecraft.class_1799;

public class TurtleRefuelCommand
implements TurtleCommand {
    private final int limit;

    public TurtleRefuelCommand(int limit) {
        this.limit = limit;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        int slot = turtle.getSelectedSlot();
        class_1799 stack = turtle.getInventory().method_5438(slot);
        if (stack.method_7960()) {
            return TurtleCommandResult.failure("No items to combust");
        }
        OptionalInt refuelled = TurtleRefuelHandlers.refuel(turtle, stack, slot, this.limit);
        if (refuelled.isEmpty()) {
            return TurtleCommandResult.failure("Items not combustible");
        }
        int newFuel = refuelled.getAsInt();
        if (newFuel != 0) {
            turtle.addFuel(newFuel);
            turtle.playAnimation(TurtleAnimation.WAIT);
        }
        return TurtleCommandResult.success();
    }
}

