/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.math;

import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;

public class ColPos {
    protected int x;
    protected int z;
    private static final int NUM_X_BITS = 32;
    private static final int NUM_Z_BITS = 32;
    private static final long X_MASK = 0xFFFFFFFFL;
    private static final long Z_MASK = 0xFFFFFFFFL;

    public ColPos() {
        this(0, 0);
    }

    public ColPos(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public ColPos(class_2338 source) {
        this.x = source.method_10263();
        this.z = source.method_10260();
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public long toLong() {
        long i = 0L;
        i |= (long)this.getX() & 0xFFFFFFFFL;
        return i |= ((long)this.getZ() & 0xFFFFFFFFL) << 32;
    }

    public static ColPos fromLong(long packedPos) {
        int x = (int)(packedPos << 32 >> 32);
        int z = (int)(packedPos >> 32);
        return new ColPos(x, z);
    }

    public ColPos up() {
        return this.up(1);
    }

    public ColPos up(int n) {
        return this.offset(class_2350.field_11036, n);
    }

    public ColPos down() {
        return this.down(1);
    }

    public ColPos down(int n) {
        return this.offset(class_2350.field_11033, n);
    }

    public ColPos north() {
        return this.north(1);
    }

    public ColPos north(int n) {
        return this.offset(class_2350.field_11043, n);
    }

    public ColPos south() {
        return this.south(1);
    }

    public ColPos south(int n) {
        return this.offset(class_2350.field_11035, n);
    }

    public ColPos west() {
        return this.west(1);
    }

    public ColPos west(int n) {
        return this.offset(class_2350.field_11039, n);
    }

    public ColPos east() {
        return this.east(1);
    }

    public ColPos east(int n) {
        return this.offset(class_2350.field_11034, n);
    }

    public ColPos offset(class_2350 facing) {
        return this.offset(facing, 1);
    }

    public ColPos offset(class_2350 facing, int n) {
        return n == 0 ? this : new ColPos(this.getX() + facing.method_10148() * n, this.getZ() + facing.method_10165() * n);
    }

    public ColPos rotate(class_2470 rotationIn) {
        switch (rotationIn) {
            default: {
                return this;
            }
            case field_11463: {
                return new ColPos(-this.getZ(), this.getX());
            }
            case field_11464: {
                return new ColPos(-this.getX(), -this.getZ());
            }
            case field_11465: 
        }
        return new ColPos(this.getZ(), -this.getX());
    }

    public class_2338 toBlockPos() {
        return new class_2338(this.getX(), 1, this.getZ());
    }

    public static ColPos fromBlockPos(class_2338 blockPos) {
        return new ColPos(blockPos);
    }

    public static class Mutable
    extends ColPos {
        public Mutable() {
        }

        public Mutable(class_2338 source) {
            this(source.method_10263(), source.method_10260());
        }

        public Mutable(ColPos pos) {
            this(pos.getX(), pos.getZ());
        }

        public Mutable(int x, int z) {
            super(x, z);
        }

        public Mutable set(int x, int z) {
            this.x = x;
            this.z = z;
            return this;
        }

        public Mutable set(ColPos source) {
            this.set(source.getX(), source.getZ());
            return this;
        }

        public Mutable set(class_2338 source) {
            this.set(source.method_10263(), source.method_10260());
            return this;
        }

        public Mutable move(class_2350 facing, int n) {
            return this.set(this.x + facing.method_10148() * n, this.z + facing.method_10165() * n);
        }

        public Mutable move(class_2350 facing) {
            return this.move(facing, 1);
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setZ(int z) {
            this.z = z;
        }
    }
}

