/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.handler;

import fuzs.illagerinvasion.IllagerInvasion;
import fuzs.illagerinvasion.config.ServerConfig;
import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.DefaultedInt;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5455;
import net.minecraft.class_8053;
import org.jetbrains.annotations.Nullable;

public class PlatinumTrimHandler {
    public static final String INSIGHT_TRANSLATION_KEY = "trim_material.illagerinvasion.platinum.effect.insight";
    public static final String AGILITY_TRANSLATION_KEY = "trim_material.illagerinvasion.platinum.effect.agility";
    public static final String ENDURANCE_TRANSLATION_KEY = "trim_material.illagerinvasion.platinum.effect.endurance";
    public static final String FEATHERWEIGHT_TRANSLATION_KEY = "trim_material.illagerinvasion.platinum.effect.featherweight";
    public static final Map<class_1738.class_8051, String> PLATINUM_TRIM_TRANSLATION_KEYS = Collections.unmodifiableMap((Map)class_156.method_654(new EnumMap(class_1738.class_8051.class), enumMap -> {
        enumMap.put(class_1738.class_8051.field_41937, FEATHERWEIGHT_TRANSLATION_KEY);
        enumMap.put(class_1738.class_8051.field_41936, ENDURANCE_TRANSLATION_KEY);
        enumMap.put(class_1738.class_8051.field_41935, AGILITY_TRANSLATION_KEY);
        enumMap.put(class_1738.class_8051.field_41934, INSIGHT_TRANSLATION_KEY);
    }));

    public static EventResult onBreakSpeed(class_1657 player, class_2680 state, DefaultedFloat breakSpeed) {
        if (player.method_31548().method_7370(state) == 1.0f && PlatinumTrimHandler.hasPlatinumTrim(player, class_1304.field_6174)) {
            breakSpeed.mapFloat(f -> Float.valueOf(f.floatValue() * 1.5f));
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingExperienceDrop(class_1309 entity, @Nullable class_1657 attackingPlayer, DefaultedInt droppedExperience) {
        if (attackingPlayer != null && PlatinumTrimHandler.hasPlatinumTrim(attackingPlayer, class_1304.field_6169)) {
            droppedExperience.mapDefaultInt(i -> i + (int)Math.max(1.0f, (float)i * 0.2f));
        }
        return EventResult.PASS;
    }

    public static EventResult onFarmlandTrample(class_1937 level, class_2338 pos, class_2680 state, float fallDistance, class_1297 entity) {
        class_1657 player;
        return entity instanceof class_1657 && PlatinumTrimHandler.hasPlatinumTrim(player = (class_1657)entity, class_1304.field_6166) ? EventResult.INTERRUPT : EventResult.PASS;
    }

    public static boolean hasPlatinumTrim(class_1657 player, class_1304 equipmentSlot) {
        return PlatinumTrimHandler.getPlatinumTrim(player.method_37908(), player.method_6118(equipmentSlot)).isPresent();
    }

    public static Optional<class_8053> getPlatinumTrim(class_1937 level, class_1799 stack) {
        if (!((ServerConfig)IllagerInvasion.CONFIG.get(ServerConfig.class)).platinumTrimEffects) {
            return Optional.empty();
        }
        return class_8053.method_48428((class_5455)level.method_30349(), (class_1799)stack).filter(armorTrim -> armorTrim.method_48431().method_40225(ModRegistry.PLATINUM_TRIM_MATERIAL));
    }
}

