/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content;

import com.hlysine.create_power_loader.CPLBlockEntityTypes;
import com.hlysine.create_power_loader.content.AbstractChunkLoaderBlockEntity;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.WeakCollection;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.utility.Pair;
import io.github.fabricators_of_create.porting_lib.chunk.loading.PortingLibChunkManager;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ChunkLoadManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SAVED_CHUNKS_DISCARD_TICKS = 100;
    private static final List<Pair<UUID, Set<LoadedChunkPos>>> unforceQueue = new LinkedList<Pair<UUID, Set<LoadedChunkPos>>>();
    private static final Map<UUID, Set<LoadedChunkPos>> savedForcedChunks = new HashMap<UUID, Set<LoadedChunkPos>>();
    private static int savedChunksDiscardCountdown = 100;
    public static class_1937 tickLevel;
    public static final Map<LoaderMode, WeakCollection<ChunkLoader>> allLoaders;

    public static void addLoader(LoaderMode mode, ChunkLoader loader) {
        allLoaders.computeIfAbsent(mode, $ -> new WeakCollection()).add(loader);
    }

    public static void removeLoader(LoaderMode mode, ChunkLoader loader) {
        allLoaders.computeIfAbsent(mode, $ -> new WeakCollection()).remove(loader);
    }

    public static void onServerWorldTick(class_1937 level) {
        if (level.method_8608()) {
            return;
        }
        MinecraftServer server = level.method_8503();
        if (savedChunksDiscardCountdown == 0) {
            for (Map.Entry<UUID, Set<LoadedChunkPos>> entry : savedForcedChunks.entrySet()) {
                ChunkLoadManager.unforceAllChunks(server, entry.getKey(), entry.getValue());
            }
            savedForcedChunks.clear();
        } else if (savedChunksDiscardCountdown > 0) {
            --savedChunksDiscardCountdown;
        }
        if (!unforceQueue.isEmpty()) {
            for (Pair pair : unforceQueue) {
                ChunkLoadManager.unforceAllChunks(server, (UUID)pair.getFirst(), (Set)pair.getSecond());
            }
            unforceQueue.clear();
        }
    }

    public static <T extends Comparable<? super T>> void updateForcedChunks(MinecraftServer server, LoadedChunkPos center, T owner, int loadingRange, Set<LoadedChunkPos> forcedChunks) {
        Set<LoadedChunkPos> targetChunks = ChunkLoadManager.getChunksAroundCenter(center, loadingRange);
        ChunkLoadManager.updateForcedChunks(server, targetChunks, owner, forcedChunks);
    }

    public static <T extends Comparable<? super T>> void updateForcedChunks(MinecraftServer server, Collection<LoadedChunkPos> centers, T owner, int loadingRange, Set<LoadedChunkPos> forcedChunks) {
        HashSet<LoadedChunkPos> targetChunks = new HashSet<LoadedChunkPos>();
        for (LoadedChunkPos center : centers) {
            targetChunks.addAll(ChunkLoadManager.getChunksAroundCenter(center, loadingRange));
        }
        ChunkLoadManager.updateForcedChunks(server, targetChunks, owner, forcedChunks);
    }

    public static <T extends Comparable<? super T>> void updateForcedChunks(MinecraftServer server, Collection<LoadedChunkPos> newChunks, T owner, Set<LoadedChunkPos> forcedChunks) {
        HashSet<LoadedChunkPos> unforcedChunks = new HashSet<LoadedChunkPos>();
        for (LoadedChunkPos chunk : forcedChunks) {
            if (newChunks.contains(chunk)) {
                newChunks.remove(chunk);
                continue;
            }
            ChunkLoadManager.forceChunk(server, owner, chunk.dimension(), chunk.x(), chunk.z(), false);
            unforcedChunks.add(chunk);
        }
        forcedChunks.removeAll(unforcedChunks);
        for (LoadedChunkPos chunk : newChunks) {
            ChunkLoadManager.forceChunk(server, owner, chunk.dimension(), chunk.x(), chunk.z(), true);
            forcedChunks.add(chunk);
        }
        if (unforcedChunks.size() > 0 || newChunks.size() > 0) {
            LOGGER.debug("CPL: update chunks, unloaded {}, loaded {}.", (Object)unforcedChunks.size(), (Object)newChunks.size());
        }
    }

    public static void enqueueUnforceAll(UUID owner, Set<LoadedChunkPos> forcedChunks) {
        unforceQueue.add((Pair<UUID, Set<LoadedChunkPos>>)Pair.of((Object)owner, forcedChunks));
    }

    public static <T extends Comparable<? super T>> void unforceAllChunks(MinecraftServer server, T owner, Set<LoadedChunkPos> forcedChunks) {
        for (LoadedChunkPos chunk : forcedChunks) {
            ChunkLoadManager.forceChunk(server, owner, chunk.dimension(), chunk.x(), chunk.z(), false);
        }
        if (forcedChunks.size() > 0) {
            LOGGER.debug("CPL: unload all, unloaded {} chunks.", (Object)forcedChunks.size());
        }
        forcedChunks.clear();
    }

    private static Set<LoadedChunkPos> getChunksAroundCenter(LoadedChunkPos center, int radius) {
        HashSet<LoadedChunkPos> ret = new HashSet<LoadedChunkPos>();
        for (int i = center.x() - radius + 1; i <= center.x() + radius - 1; ++i) {
            for (int j = center.z() - radius + 1; j <= center.z() + radius - 1; ++j) {
                ret.add(new LoadedChunkPos(center.dimension(), i, j));
            }
        }
        return ret;
    }

    private static <T extends Comparable<? super T>> void forceChunk(MinecraftServer server, T owner, class_2960 dimension, int chunkX, int chunkZ, boolean add) {
        class_3218 targetLevel = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimension));
        assert (targetLevel != null);
        if (owner instanceof class_2338) {
            PortingLibChunkManager.forceChunk((class_3218)targetLevel, (String)"create_power_loader", (class_2338)((class_2338)owner), (int)chunkX, (int)chunkZ, (boolean)add, (boolean)true);
        } else {
            PortingLibChunkManager.forceChunk((class_3218)targetLevel, (String)"create_power_loader", (UUID)((UUID)owner), (int)chunkX, (int)chunkZ, (boolean)add, (boolean)true);
        }
    }

    public static Set<LoadedChunkPos> getSavedForcedChunks(UUID entityUUID) {
        return savedForcedChunks.remove(entityUUID);
    }

    public static void validateAllForcedChunks(class_3218 level, PortingLibChunkManager.TicketHelper helper) {
        helper.getBlockTickets().forEach((blockPos, tickets) -> {
            LOGGER.debug("CPL: Inspecting level {} position {} which has {} non-ticking tickets and {} ticking tickets.", new Object[]{level.method_27983().method_29177(), blockPos.method_23854(), ((LongSet)tickets.getFirst()).size(), ((LongSet)tickets.getSecond()).size()});
            AbstractChunkLoaderBlockEntity blockEntity = level.method_35230(blockPos, (class_2591)CPLBlockEntityTypes.BRASS_CHUNK_LOADER.get()).orElse(null);
            if (blockEntity == null) {
                blockEntity = level.method_35230(blockPos, (class_2591)CPLBlockEntityTypes.ANDESITE_CHUNK_LOADER.get()).orElse(null);
            }
            if (blockEntity == null) {
                helper.removeAllTickets(blockPos);
                LOGGER.debug("CPL: level {} position {} unforced: Cannot find block entity.", (Object)level.method_27983().method_29177(), (Object)blockPos.method_23854());
                return;
            }
            for (Long chunk : (LongSet)tickets.getFirst()) {
                class_1923 chunkPos = new class_1923(chunk.longValue());
                helper.removeTicket(blockPos, chunk.longValue(), false);
                LOGGER.debug("CPL: level {} position {} unforced non-ticking {}", new Object[]{level.method_27983().method_29177(), blockPos.method_23854(), chunkPos});
            }
            HashSet<LoadedChunkPos> forcedChunks = new HashSet<LoadedChunkPos>();
            for (Long chunk : (LongSet)tickets.getSecond()) {
                class_1923 chunkPos = new class_1923(chunk.longValue());
                forcedChunks.add(new LoadedChunkPos(level.method_27983().method_29177(), chunkPos));
            }
            blockEntity.reclaimChunks(forcedChunks);
            LOGGER.debug("CPL: level {} position {} reclaimed {} chunks.", new Object[]{level.method_27983().method_29177(), blockPos.method_23854(), forcedChunks.size()});
        });
        helper.getEntityTickets().forEach((entityUUID, tickets) -> {
            Set<Object> savedChunks = new HashSet();
            if (savedForcedChunks.containsKey(entityUUID)) {
                savedChunks = savedForcedChunks.get(entityUUID);
            }
            for (Long chunk : (LongSet)tickets.getFirst()) {
                savedChunks.add(new LoadedChunkPos((class_1937)level, chunk));
            }
            for (Long chunk : (LongSet)tickets.getSecond()) {
                savedChunks.add(new LoadedChunkPos((class_1937)level, chunk));
            }
            savedForcedChunks.put((UUID)entityUUID, (Set<LoadedChunkPos>)savedChunks);
            LOGGER.debug("CPL: Inspecting entity {} which has {} non-ticking tickets and {} ticking tickets.", new Object[]{entityUUID, ((LongSet)tickets.getFirst()).size(), ((LongSet)tickets.getSecond()).size()});
        });
        savedChunksDiscardCountdown = 100;
    }

    public static void reclaimChunks(class_1937 level, UUID owner, Map<class_5321<class_1937>, Set<LoadedChunkPos>> reclaimedChunks) {
        Set<LoadedChunkPos> oldChunks = ChunkLoadManager.getSavedForcedChunks(owner);
        if (oldChunks != null) {
            for (LoadedChunkPos chunk : oldChunks) {
                class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)chunk.dimension());
                Set<LoadedChunkPos> reclaim = reclaimedChunks.get(key);
                if (reclaim != null) {
                    reclaim.add(chunk);
                    continue;
                }
                reclaim = new HashSet<LoadedChunkPos>();
                reclaim.add(chunk);
                reclaimedChunks.put((class_5321<class_1937>)key, reclaim);
            }
        }
        if (!reclaimedChunks.isEmpty()) {
            MinecraftServer server = level.method_8503();
            assert (server != null);
            Iterator<Map.Entry<class_5321<class_1937>, Set<LoadedChunkPos>>> iterator = reclaimedChunks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<class_5321<class_1937>, Set<LoadedChunkPos>> entry = iterator.next();
                class_3218 reclaimLevel = server.method_3847(entry.getKey());
                if (reclaimLevel == null) continue;
                ChunkLoadManager.unforceAllChunks(server, owner, entry.getValue());
                iterator.remove();
            }
        }
    }

    static {
        allLoaders = new HashMap<LoaderMode, WeakCollection<ChunkLoader>>();
    }

    public record LoadedChunkPos(@NotNull class_2960 dimension, @NotNull class_1923 chunkPos) {
        public LoadedChunkPos(@NotNull class_1937 level, long chunkPos) {
            this(level.method_27983().method_29177(), new class_1923(chunkPos));
        }

        public LoadedChunkPos(@NotNull class_2960 level, int pX, int pZ) {
            this(level, new class_1923(pX, pZ));
        }

        public LoadedChunkPos(@NotNull class_1937 level, class_2338 blockPos) {
            this(level.method_27983().method_29177(), new class_1923(blockPos));
        }

        public int x() {
            return this.chunkPos.field_9181;
        }

        public int z() {
            return this.chunkPos.field_9180;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LoadedChunkPos)) {
                return false;
            }
            LoadedChunkPos loadedChunk = (LoadedChunkPos)obj;
            if (!Objects.equals(loadedChunk.dimension, this.dimension)) {
                return false;
            }
            return Objects.equals(loadedChunk.chunkPos, this.chunkPos);
        }

        @Override
        public String toString() {
            return this.dimension + ":" + this.chunkPos;
        }
    }
}

