/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content;

import com.hlysine.create_power_loader.config.CPLConfigs;
import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.ContraptionRenderer;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.LoaderType;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.logging.LogUtils;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.foundation.utility.Pair;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChunkLoaderMovementBehaviour
implements MovementBehaviour {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final LoaderType type;

    public ChunkLoaderMovementBehaviour(LoaderType type) {
        this.type = type;
    }

    public void startMoving(MovementContext context) {
        if (context.world.field_9236 || !(context.world instanceof class_3218)) {
            return;
        }
        if (context.contraption.entity == null) {
            return;
        }
        Object tempState = context.temporaryData;
        if (!(tempState instanceof SavedState)) {
            tempState = new SavedState(this.type, null, null, context.contraption instanceof CarriageContraption, new HashSet<ChunkLoadManager.LoadedChunkPos>());
        }
        SavedState savedState = (SavedState)tempState;
        savedState.chunkPos = null;
        context.temporaryData = savedState;
    }

    public void visitNewPosition(MovementContext context, class_2338 pos) {
        if (context.world.field_9236 || !(context.world instanceof class_3218)) {
            return;
        }
        if (context.contraption.entity == null) {
            return;
        }
        ChunkLoadManager.LoadedChunkPos entityChunkPos = new ChunkLoadManager.LoadedChunkPos(context.world.method_27983().method_29177(), context.contraption.entity.method_31476());
        class_2338 entityBlockPos = context.contraption.entity.method_24515();
        Object tempState = context.temporaryData;
        if (!(tempState instanceof SavedState)) {
            context.temporaryData = tempState = new SavedState(this.type, null, null, context.contraption instanceof CarriageContraption, new HashSet<ChunkLoadManager.LoadedChunkPos>());
        }
        SavedState savedState = (SavedState)tempState;
        if (entityChunkPos.equals(savedState.chunkPos)) {
            return;
        }
        savedState.chunkPos = entityChunkPos;
        savedState.blockPos = entityBlockPos;
        if (this.shouldFunction(context)) {
            ChunkLoadManager.updateForcedChunks(context.world.method_8503(), entityChunkPos, context.contraption.entity.method_5667(), (int)((Integer)CPLConfigs.server().getFor((LoaderType)savedState.loaderType).rangeOnContraption.get()), savedState.forcedChunks);
            LOGGER.debug("CPL: Entity {} at new chunk {}, loaded {} chunks", new Object[]{context.contraption.entity, entityChunkPos, savedState.forcedChunks.size()});
        } else {
            ChunkLoadManager.unforceAllChunks(context.world.method_8503(), context.contraption.entity.method_5667(), savedState.forcedChunks);
        }
        context.temporaryData = savedState;
    }

    public void tick(MovementContext context) {
        if (context.world.field_9236 || !(context.world instanceof class_3218)) {
            return;
        }
        if (context.contraption.entity == null) {
            return;
        }
        class_2960 dimension = context.world.method_27983().method_29177();
        ChunkLoadManager.LoadedChunkPos entityChunkPos = new ChunkLoadManager.LoadedChunkPos(dimension, context.contraption.entity.method_31476());
        class_2338 entityBlockPos = context.contraption.entity.method_24515();
        Object tempState = context.temporaryData;
        if (!(tempState instanceof SavedState)) {
            context.temporaryData = tempState = new SavedState(this.type, entityChunkPos, entityBlockPos, context.contraption instanceof CarriageContraption, new HashSet<ChunkLoadManager.LoadedChunkPos>());
            SavedState savedState = (SavedState)tempState;
            Set<ChunkLoadManager.LoadedChunkPos> savedForcedChunks = ChunkLoadManager.getSavedForcedChunks(context.contraption.entity.method_5667());
            if (savedForcedChunks != null) {
                ((SavedState)tempState).forcedChunks.addAll(savedForcedChunks);
                LOGGER.debug("CPL: Entity {} reclaimed {} chunks", (Object)context.contraption.entity, (Object)savedForcedChunks.size());
            }
            if (this.shouldFunction(context)) {
                ChunkLoadManager.updateForcedChunks(context.world.method_8503(), entityChunkPos, context.contraption.entity.method_5667(), (int)((Integer)CPLConfigs.server().getFor((LoaderType)savedState.loaderType).rangeOnContraption.get()), savedState.forcedChunks);
                LOGGER.debug("CPL: Entity {} starts moving at chunk {}, loaded {} chunks", new Object[]{context.contraption.entity, entityChunkPos, savedState.forcedChunks.size()});
            } else {
                ChunkLoadManager.unforceAllChunks(context.world.method_8503(), context.contraption.entity.method_5667(), savedState.forcedChunks);
            }
            savedState.chunkPos = entityChunkPos;
            savedState.blockPos = entityBlockPos;
        }
    }

    public void stopMoving(MovementContext context) {
        if (context.world.field_9236 || !(context.world instanceof class_3218)) {
            return;
        }
        if (context.contraption.entity == null) {
            return;
        }
        Object tempState = context.temporaryData;
        if (!(tempState instanceof SavedState)) {
            return;
        }
        SavedState savedState = (SavedState)tempState;
        if (this.shouldFunction(context)) {
            LOGGER.debug("CPL: Entity {} stops moving in {}, unloaded {} chunks", new Object[]{context.contraption.entity, savedState.chunkPos, savedState.forcedChunks.size()});
        }
        ChunkLoadManager.unforceAllChunks(context.world.method_8503(), context.contraption.entity.method_5667(), savedState.forcedChunks);
        savedState.chunkPos = null;
        savedState.blockPos = null;
        savedState.removeFromManager();
        context.temporaryData = null;
    }

    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        ContraptionRenderer.renderInContraption(context, renderWorld, matrices, buffer, this.type);
    }

    private boolean shouldFunction(MovementContext context) {
        if (context.contraption instanceof CarriageContraption) {
            return false;
        }
        return (Boolean)CPLConfigs.server().getFor((LoaderType)this.type).enableContraption.get();
    }

    public static class SavedState
    implements ChunkLoader {
        private final LoaderType loaderType;
        @Nullable
        public ChunkLoadManager.LoadedChunkPos chunkPos;
        @Nullable
        public class_2338 blockPos;
        public final boolean isTrain;
        public Set<ChunkLoadManager.LoadedChunkPos> forcedChunks;
        public boolean registered = false;

        public SavedState(LoaderType type, @Nullable ChunkLoadManager.LoadedChunkPos chunkPos, @Nullable class_2338 blockPos, boolean isTrain, Set<ChunkLoadManager.LoadedChunkPos> forcedChunks) {
            this.loaderType = type;
            this.chunkPos = chunkPos;
            this.blockPos = blockPos;
            this.isTrain = isTrain;
            this.forcedChunks = forcedChunks;
            this.addToManager();
        }

        @Override
        @NotNull
        public Set<ChunkLoadManager.LoadedChunkPos> getForcedChunks() {
            return this.forcedChunks;
        }

        @Override
        public LoaderMode getLoaderMode() {
            return LoaderMode.CONTRAPTION;
        }

        @Override
        public LoaderType getLoaderType() {
            return this.loaderType;
        }

        @Override
        public void addToManager() {
            if (!this.isTrain) {
                ChunkLoader.super.addToManager();
            }
        }

        @Override
        @Nullable
        public Pair<class_2960, class_2338> getLocation() {
            if (this.chunkPos == null || this.blockPos == null) {
                return null;
            }
            return Pair.of((Object)this.chunkPos.dimension(), (Object)this.blockPos);
        }
    }
}

