/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.renderer;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2478;
import net.minecraft.class_2508;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_8242;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public interface ICanvasSignRenderer {
    public static final int OUTLINE_RENDER_DISTANCE = class_3532.method_34954((int)16);
    public static final class_243 TEXT_OFFSET = new class_243(0.0, (double)-0.32f, (double)0.073f);

    default public void renderSignWithText(class_2625 signBlockEntity, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_2680 state, class_2478 block, @Nullable class_1767 dye, class_3879 model) {
        poseStack.method_22903();
        this.method_65824(poseStack, -block.method_49814(state), state);
        this.renderSign(poseStack, bufferSource, packedLight, packedOverlay, dye, model);
        this.renderSignText(signBlockEntity.method_11016(), signBlockEntity.method_49853(), poseStack, bufferSource, packedLight, signBlockEntity.method_45469(), signBlockEntity.method_45470(), true);
        this.renderSignText(signBlockEntity.method_11016(), signBlockEntity.method_49854(), poseStack, bufferSource, packedLight, signBlockEntity.method_45469(), signBlockEntity.method_45470(), false);
        poseStack.method_22909();
    }

    default public void method_65824(class_4587 poseStack, float angle, class_2680 state) {
        poseStack.method_46416(0.5f, 0.75f * this.method_51272(), 0.5f);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(angle));
        if (!(state.method_26204() instanceof class_2508)) {
            poseStack.method_46416(0.0f, -0.3125f, -0.4375f);
        }
    }

    default public void renderSign(class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, @Nullable class_1767 dye, class_3879 model) {
        poseStack.method_22903();
        float rootScale = this.method_51272();
        poseStack.method_22905(rootScale, -rootScale, -rootScale);
        class_4730 material = this.getCanvasSignMaterial(dye);
        class_4588 vertexConsumer = material.method_24145(bufferSource, arg_0 -> ((class_3879)model).method_23500(arg_0));
        this.renderSignModel(poseStack, packedLight, packedOverlay, model, vertexConsumer);
        poseStack.method_22909();
    }

    default public void renderSignModel(class_4587 poseStack, int packedLight, int packedOverlay, class_3879 model, class_4588 vertexConsumer) {
        model.method_60879(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    default public void renderSignText(class_2338 pos, class_8242 text, class_4587 poseStack, class_4597 bufferSource, int packedLight, int textLineHeight, int maxTextLineWidth, boolean isFrontText) {
        int light;
        boolean hasOutline;
        int baseColor;
        int darkColor;
        poseStack.method_22903();
        this.translateSignText(poseStack, isFrontText, this.method_45790());
        class_5481[] formattedCharSequenceList = text.method_49868(class_310.method_1551().method_33883(), component -> {
            List list = class_310.method_1551().field_1772.method_1728((class_5348)component, maxTextLineWidth);
            return list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
        });
        if (text.method_49856()) {
            darkColor = ICanvasSignRenderer.getDarkColor(text, true);
            baseColor = text.method_49872().method_16357();
            hasOutline = ICanvasSignRenderer.isOutlineVisible(pos, baseColor);
            light = 0xF000F0;
        } else {
            baseColor = darkColor = ICanvasSignRenderer.getDarkColor(text, false);
            hasOutline = false;
            light = packedLight;
        }
        int verticalOffset = 2 * textLineHeight + this.getCustomVerticalOffset();
        for (int i = 0; i < 4; ++i) {
            class_5481 formattedCharSequence = formattedCharSequenceList[i];
            float x = -class_310.method_1551().field_1772.method_30880(formattedCharSequence) / 2;
            float y = i * textLineHeight - verticalOffset;
            if (hasOutline) {
                class_310.method_1551().field_1772.method_37296(formattedCharSequence, x, y, baseColor, darkColor, poseStack.method_23760().method_23761(), bufferSource, light);
                continue;
            }
            class_310.method_1551().field_1772.method_22942(formattedCharSequence, x, y, baseColor, false, poseStack.method_23760().method_23761(), bufferSource, class_327.class_6415.field_33995, 0, light);
        }
        poseStack.method_22909();
    }

    default public void translateSignText(class_4587 poseStack, boolean isFrontText, class_243 pos) {
        if (!isFrontText) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        }
        float textScale = 0.015625f * this.method_51273();
        poseStack.method_22904(pos.field_1352, pos.field_1351, pos.field_1350);
        poseStack.method_22905(textScale, -textScale, textScale);
    }

    public static boolean isOutlineVisible(class_2338 pos, int textColor) {
        if (textColor == class_1767.field_7963.method_16357()) {
            return true;
        }
        class_310 minecraft = class_310.method_1551();
        class_746 localPlayer = minecraft.field_1724;
        if (localPlayer != null && minecraft.field_1690.method_31044().method_31034() && localPlayer.method_31550()) {
            return true;
        }
        class_1297 entity = minecraft.method_1560();
        return entity != null && entity.method_5707(class_243.method_24953((class_2382)pos)) < (double)OUTLINE_RENDER_DISTANCE;
    }

    public static int getDarkColor(class_8242 text, boolean isOutlineVisible) {
        int textColor = text.method_49872().method_16357();
        if (textColor == class_1767.field_7963.method_16357() && text.method_49856()) {
            return -988212;
        }
        double brightness = isOutlineVisible ? 0.4 : 0.6;
        int red = (int)((double)class_9848.method_61327((int)textColor) * brightness);
        int green = (int)((double)class_9848.method_61329((int)textColor) * brightness);
        int blue = (int)((double)class_9848.method_61331((int)textColor) * brightness);
        return class_9848.method_61324((int)255, (int)red, (int)green, (int)blue);
    }

    default public int getCustomVerticalOffset() {
        return -1;
    }

    public class_4730 getCanvasSignMaterial(@Nullable class_1767 var1);

    public float method_51272();

    public float method_51273();

    public class_243 method_45790();
}

