/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_10225;
import net.minecraft.class_10290;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.entity.SkilletBlockEntity;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ModTags;

public class SkilletBlock
extends class_2237
implements class_3737 {
    public static final MapCodec<SkilletBlock> CODEC = SkilletBlock.method_54094(SkilletBlock::new);
    public static final int MINIMUM_COOKING_TIME = 60;
    public static final class_2769<class_2350> FACING = class_2741.field_12481;
    public static final class_2746 SUPPORT = class_2746.method_11825((String)"support");
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static final class_265 SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    protected static final class_265 SHAPE_WITH_TRAY = class_259.method_1084((class_265)SHAPE, (class_265)class_2248.method_9541((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));

    public SkilletBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)SUPPORT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 tileEntity = level.method_8321(pos);
        if (tileEntity instanceof SkilletBlockEntity) {
            class_1304 heldSlot;
            SkilletBlockEntity skilletEntity = (SkilletBlockEntity)tileEntity;
            class_1799 heldStack = player.method_5998(hand);
            class_1304 class_13042 = heldSlot = hand.equals((Object)class_1268.field_5808) ? class_1304.field_6173 : class_1304.field_6171;
            if (heldStack.method_7960()) {
                class_1799 extractedStack = skilletEntity.removeItem();
                if (!player.method_68878()) {
                    player.method_5673(heldSlot, extractedStack);
                }
                return class_1269.field_5812;
            }
            if (!skilletEntity.hasStoredStack() && level.method_8433().method_64678(class_10290.field_54653).method_64701(heldStack)) {
                if (!(level instanceof class_3218)) {
                    return class_1269.field_5812;
                }
                class_3218 serverLevel = (class_3218)level;
                class_1799 remainderStack = skilletEntity.addItemToCook(heldStack, player, serverLevel);
                if (remainderStack.method_7947() != heldStack.method_7947()) {
                    if (!player.method_68878()) {
                        player.method_5673(heldSlot, remainderStack);
                    }
                    level.method_8396(null, pos, class_3417.field_17743, class_3419.field_15245, 0.7f, 1.0f);
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_21466;
        }
        return class_1269.field_52423;
    }

    public class_2464 method_9604(class_2680 pState) {
        return class_2464.field_11458;
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return ((Boolean)state.method_11654((class_2769)SUPPORT)).equals(true) ? SHAPE_WITH_TRAY : SHAPE;
    }

    public class_2680 method_9605(class_1750 context) {
        class_1937 level = context.method_8045();
        class_3610 fluid = level.method_8316(context.method_8037());
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)context.method_8042())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.method_15772() == class_3612.field_15910))).method_11657((class_2769)SUPPORT, (Comparable)Boolean.valueOf(this.getTrayState((class_4538)context.method_8045(), context.method_8037())));
    }

    public class_2680 method_9559(class_2680 state, class_4538 level, class_10225 scheduledTickAccess, class_2338 currentPos, class_2350 facing, class_2338 facingPos, class_2680 facingState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.method_64312(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(level));
        }
        if (facing.method_10166().equals((Object)class_2350.class_2351.field_11052)) {
            return (class_2680)state.method_11657((class_2769)SUPPORT, (Comparable)Boolean.valueOf(this.getTrayState(level, currentPos)));
        }
        return state;
    }

    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state, boolean includeData) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof SkilletBlockEntity) {
            SkilletBlockEntity skillet = (SkilletBlockEntity)class_25862;
            return skillet.getSkilletAsItem();
        }
        return super.method_9574(level, pos, state, includeData);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, SUPPORT, WATERLOGGED});
    }

    public void method_9496(class_2680 stateIn, class_1937 level, class_2338 pos, class_5819 rand) {
        SkilletBlockEntity skilletEntity;
        class_2586 tileEntity = level.method_8321(pos);
        if (tileEntity instanceof SkilletBlockEntity && (skilletEntity = (SkilletBlockEntity)tileEntity).isCooking()) {
            double x = (double)pos.method_10263() + 0.5;
            double y = pos.method_10264();
            double z = (double)pos.method_10260() + 0.5;
            if (rand.method_43048(10) == 0) {
                level.method_8486(x, y, z, ModSounds.BLOCK_SKILLET_SIZZLE.get(), class_3419.field_15245, 0.4f, rand.method_43057() * 0.2f + 0.9f, false);
            }
        }
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return ModBlockEntityTypes.SKILLET.get().method_11032(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntity) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            return SkilletBlock.method_31618(blockEntity, ModBlockEntityTypes.SKILLET.get(), (_level, blockPos, blockState, skilletEntity) -> SkilletBlockEntity.cookingTick(serverLevel, blockPos, blockState, skilletEntity));
        }
        return SkilletBlock.method_31618(blockEntity, ModBlockEntityTypes.SKILLET.get(), SkilletBlockEntity::animationTick);
    }

    private boolean getTrayState(class_4538 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_26164(ModTags.TRAY_HEAT_SOURCES);
    }

    public static int getSkilletCookingTime(int originalCookingTime, int fireAspectLevel) {
        int cookingTime = originalCookingTime > 0 ? originalCookingTime : 600;
        int cookingSeconds = cookingTime / 20;
        float cookingTimeReduction = 0.2f;
        if (fireAspectLevel > 0) {
            cookingTimeReduction = (float)((double)cookingTimeReduction - (double)fireAspectLevel * 0.05);
        }
        int result = (int)((float)cookingSeconds * cookingTimeReduction) * 20;
        return class_3532.method_15340((int)result, (int)60, (int)originalCookingTime);
    }
}

