/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.refabricated.inventory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_128;
import net.minecraft.class_148;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.refabricated.inventory.ItemHandler;
import vectorwing.farmersdelight.refabricated.inventory.ItemHandlerStackWrapper;

public abstract class FabricWrappedInventory
implements ItemHandler {
    private final List<ItemHandlerStackWrapper> fabricWrappers;

    public FabricWrappedInventory(int size) {
        this.fabricWrappers = new ArrayList<ItemHandlerStackWrapper>(size);
        for (int i = 0; i < size; ++i) {
            this.fabricWrappers.add(new ItemHandlerStackWrapper(this, i));
        }
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return (SingleSlotStorage)this.fabricWrappers.get(slot);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long amount = 0L;
        try {
            for (ItemHandlerStackWrapper wrapper : this.fabricWrappers) {
                if ((amount += wrapper.insert(resource, maxAmount - amount, transaction)) != maxAmount) continue;
                return maxAmount;
            }
        }
        catch (Exception ex) {
            class_128 report = class_128.method_560((Throwable)ex, (String)"Inserting resources into slots");
            report.method_562("Slotted insertion details").method_577("Slots", () -> Objects.toString(this.fabricWrappers, null)).method_577("Resource", () -> Objects.toString(resource, null)).method_578("Max amount", (Object)maxAmount).method_578("Transaction", (Object)transaction);
            throw new class_148(report);
        }
        return amount;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long amount = 0L;
        try {
            for (ItemHandlerStackWrapper wrapper : this.fabricWrappers) {
                if ((amount += wrapper.extract(resource, maxAmount - amount, transaction)) != maxAmount) continue;
                return maxAmount;
            }
        }
        catch (Exception ex) {
            class_128 report = class_128.method_560((Throwable)ex, (String)"Inserting resources into slots");
            report.method_562("Slotted insertion details").method_577("Slots", () -> Objects.toString(this.fabricWrappers, null)).method_577("Resource", () -> Objects.toString(resource, null)).method_578("Max amount", (Object)maxAmount).method_578("Transaction", (Object)transaction);
            throw new class_148(report);
        }
        return amount;
    }

    @NotNull
    public Iterator<StorageView<ItemVariant>> iterator() {
        return this.getSlots().stream().map(storageViews -> storageViews).iterator();
    }
}

