/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10124;
import net.minecraft.class_10712;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4174;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import net.minecraft.class_9334;
import org.joml.Matrix3x2fStack;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.event.TooltipOverlayEvent;
import squeek.appleskin.api.handler.EventHandler;
import squeek.appleskin.helpers.ColorHelper;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.KeyHelper;
import squeek.appleskin.helpers.TextureHelper;

public class TooltipOverlayHandler {
    public static TooltipOverlayHandler INSTANCE;

    public static void init() {
        INSTANCE = new TooltipOverlayHandler();
    }

    public void onItemTooltip(class_1799 hoveredStack, class_1657 player, class_1792.class_9635 context, class_1836 type, List tooltip) {
        if (hoveredStack == null || tooltip == null || ModConfig.INSTANCE == null) {
            return;
        }
        if (!this.shouldShowTooltip(hoveredStack, type)) {
            return;
        }
        FoodHelper.QueriedFoodResult queriedFoodResult = FoodHelper.query(hoveredStack, player);
        if (queriedFoodResult == null) {
            return;
        }
        class_4174 defaultFood = queriedFoodResult.defaultFoodComponent;
        class_4174 modifiedFood = queriedFoodResult.modifiedFoodComponent;
        TooltipOverlayEvent.Pre prerenderEvent = new TooltipOverlayEvent.Pre(hoveredStack, defaultFood, modifiedFood);
        ((EventHandler)TooltipOverlayEvent.Pre.EVENT.invoker()).interact(prerenderEvent);
        if (prerenderEvent.isCanceled) {
            return;
        }
        FoodOverlay foodOverlay = new FoodOverlay(prerenderEvent.itemStack, defaultFood, modifiedFood, queriedFoodResult.consumableComponent, player);
        if (foodOverlay.shouldRenderHungerBars()) {
            try {
                tooltip.add(new FoodOverlayTextComponent(foodOverlay));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    public void onRenderTooltip(class_332 context, FoodOverlay foodOverlay, int toolTipX, int toolTipY, class_327 textRenderer) {
        if (context == null || ModConfig.INSTANCE == null) {
            return;
        }
        if (foodOverlay == null) {
            return;
        }
        class_1799 itemStack = foodOverlay.itemStack;
        class_4174 defaultFood = foodOverlay.defaultFood;
        class_4174 modifiedFood = foodOverlay.modifiedFood;
        int x = toolTipX;
        int y = toolTipY;
        TooltipOverlayEvent.Render renderEvent = new TooltipOverlayEvent.Render(itemStack, x, y, context, defaultFood, modifiedFood);
        ((EventHandler)TooltipOverlayEvent.Render.EVENT.invoker()).interact(renderEvent);
        if (renderEvent.isCanceled) {
            return;
        }
        x = renderEvent.x;
        y = renderEvent.y;
        context = renderEvent.context;
        itemStack = renderEvent.itemStack;
        Matrix3x2fStack matrixStack = context.method_51448();
        int defaultFoodHunger = defaultFood.comp_2491();
        int modifiedFoodHunger = modifiedFood.comp_2491();
        x += (foodOverlay.hungerBars - 1) * 9;
        boolean isRotten = FoodHelper.isRotten(foodOverlay.consumableComponent);
        for (int i = 0; i < foodOverlay.hungerBars * 2; i += 2) {
            context.method_52706(class_10799.field_56883, TextureHelper.FOOD_EMPTY_TEXTURE, x, y, 9, 9);
            FoodOutline outline = FoodOutline.get(modifiedFoodHunger, defaultFoodHunger, i);
            if (outline != FoodOutline.NORMAL) {
                context.method_52707(class_10799.field_56883, TextureHelper.HUNGER_OUTLINE_SPRITE, x, y, 9, 9, outline.argb());
            }
            boolean isDefaultHalf = defaultFoodHunger - 1 == i;
            class_2960 defaultFoodIcon = TextureHelper.getFoodTexture(isRotten, isDefaultHalf ? TextureHelper.FoodType.HALF : TextureHelper.FoodType.FULL);
            context.method_52707(class_10799.field_56883, defaultFoodIcon, x, y, 9, 9, ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, 0.25f));
            if (modifiedFoodHunger > i) {
                boolean isModifiedHalf = modifiedFoodHunger - 1 == i;
                class_2960 modifiedFoodIcon = TextureHelper.getFoodTexture(isRotten, isModifiedHalf ? TextureHelper.FoodType.HALF : TextureHelper.FoodType.FULL);
                context.method_52706(class_10799.field_56883, modifiedFoodIcon, x, y, 9, 9);
            }
            x -= 9;
        }
        if (foodOverlay.hungerBarsText != null) {
            matrixStack.pushMatrix();
            matrixStack.translate((float)(x += 18), (float)y);
            matrixStack.scale(0.75f, 0.75f);
            context.method_25303(textRenderer, foodOverlay.hungerBarsText, 2, 2, -5592406);
            matrixStack.popMatrix();
        }
        x = toolTipX;
        y += 10;
        float modifiedSaturationIncrement = modifiedFood.comp_2492();
        float absModifiedSaturationIncrement = Math.abs(modifiedSaturationIncrement);
        x += (foodOverlay.saturationBars - 1) * 7;
        for (int i = 0; i < foodOverlay.saturationBars * 2; i += 2) {
            int color;
            float effectiveSaturationOfBar = (absModifiedSaturationIncrement - (float)i) / 2.0f;
            boolean shouldBeFaded = absModifiedSaturationIncrement <= (float)i;
            int n = color = shouldBeFaded ? ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, 0.5f) : ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, 1.0f);
            context.method_25291(class_10799.field_56883, TextureHelper.MOD_ICONS, x, y, effectiveSaturationOfBar >= 1.0f ? 21.0f : ((double)effectiveSaturationOfBar > 0.5 ? 14.0f : ((double)effectiveSaturationOfBar > 0.25 ? 7.0f : (effectiveSaturationOfBar > 0.0f ? 0.0f : 28.0f))), modifiedSaturationIncrement >= 0.0f ? 27.0f : 34.0f, 7, 7, 256, 256, color);
            x -= 7;
        }
        if (foodOverlay.saturationBarsText != null) {
            matrixStack.pushMatrix();
            matrixStack.translate((float)(x += 14), (float)y);
            matrixStack.scale(0.75f, 0.75f);
            context.method_25303(textRenderer, foodOverlay.saturationBarsText, 2, 1, -5592406);
            matrixStack.popMatrix();
        }
    }

    private boolean shouldShowTooltip(class_1799 hoveredStack, class_1836 type) {
        boolean shouldShowTooltip;
        if (hoveredStack.method_7960()) {
            return false;
        }
        if (!type.method_47370() && ((class_10712)hoveredStack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318)).comp_3600()) {
            return false;
        }
        boolean bl = shouldShowTooltip = ModConfig.INSTANCE.showFoodValuesInTooltip && KeyHelper.isShiftKeyDown() || ModConfig.INSTANCE.showFoodValuesInTooltipAlways;
        if (!shouldShowTooltip) {
            return false;
        }
        return FoodHelper.isFood(hoveredStack);
    }

    public static class FoodOverlay
    implements class_5684,
    class_5632 {
        private class_4174 defaultFood;
        private class_4174 modifiedFood;
        private class_10124 consumableComponent;
        private int biggestHunger;
        private float biggestSaturationIncrement;
        private int hungerBars;
        private String hungerBarsText;
        private int saturationBars;
        private String saturationBarsText;
        private class_1799 itemStack;

        FoodOverlay(class_1799 itemStack, class_4174 defaultFood, class_4174 modifiedFood, class_10124 consumableComponent, class_1657 player) {
            this.itemStack = itemStack;
            this.defaultFood = defaultFood;
            this.modifiedFood = modifiedFood;
            this.consumableComponent = consumableComponent;
            this.biggestHunger = Math.max(defaultFood.comp_2491(), modifiedFood.comp_2491());
            this.biggestSaturationIncrement = Math.max(defaultFood.comp_2492(), modifiedFood.comp_2492());
            this.hungerBars = (int)Math.ceil((float)Math.abs(this.biggestHunger) / 2.0f);
            if (this.hungerBars > 10) {
                this.hungerBarsText = "x" + (this.biggestHunger < 0 ? -1 : 1) * this.hungerBars;
                this.hungerBars = 1;
            }
            this.saturationBars = (int)Math.ceil(Math.abs(this.biggestSaturationIncrement) / 2.0f);
            if (this.saturationBars > 10 || this.saturationBars == 0) {
                this.saturationBarsText = "x" + (this.biggestSaturationIncrement < 0.0f ? -1 : 1) * this.saturationBars;
                this.saturationBars = 1;
            }
        }

        boolean shouldRenderHungerBars() {
            return this.hungerBars > 0;
        }

        public int method_32661(class_327 textRenderer) {
            return 20;
        }

        public int method_32664(class_327 textRenderer) {
            int hungerBarLength = this.hungerBars * 9;
            if (this.hungerBarsText != null) {
                hungerBarLength += textRenderer.method_1727(this.hungerBarsText);
            }
            int saturationBarLength = this.saturationBars * 7;
            if (this.saturationBarsText != null) {
                saturationBarLength += textRenderer.method_1727(this.saturationBarsText);
            }
            return Math.max(hungerBarLength, saturationBarLength);
        }

        public void method_32666(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
            if (INSTANCE != null) {
                INSTANCE.onRenderTooltip(context, this, x, y, textRenderer);
            }
        }
    }

    public static class FoodOverlayTextComponent
    extends EmptyText
    implements class_5481 {
        public FoodOverlay foodOverlay;

        FoodOverlayTextComponent(FoodOverlay foodOverlay) {
            this.foodOverlay = foodOverlay;
        }

        public class_5481 method_30937() {
            return this;
        }

        public boolean accept(class_5224 visitor) {
            return class_5223.method_27476((class_5348)this, (class_2583)this.method_10866(), (class_5224)visitor);
        }
    }

    static enum FoodOutline {
        NEGATIVE,
        EXTRA,
        NORMAL,
        PARTIAL,
        MISSING;


        public int argb() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> ColorHelper.argbFromRGBA(1.0f, 1.0f, 1.0f, 1.0f);
                case 1 -> ColorHelper.argbFromRGBA(0.06f, 0.32f, 0.02f, 1.0f);
                case 2 -> ColorHelper.argbFromRGBA(0.0f, 0.0f, 0.0f, 1.0f);
                case 3 -> ColorHelper.argbFromRGBA(0.53f, 0.21f, 0.08f, 1.0f);
                case 4 -> ColorHelper.argbFromRGBA(0.62f, 0.0f, 0.0f, 0.5f);
            };
        }

        public static FoodOutline get(int modifiedFoodHunger, int defaultFoodHunger, int i) {
            if (modifiedFoodHunger < 0) {
                return NEGATIVE;
            }
            if (modifiedFoodHunger > defaultFoodHunger && defaultFoodHunger <= i) {
                return EXTRA;
            }
            if (modifiedFoodHunger > i + 1 || defaultFoodHunger == modifiedFoodHunger) {
                return NORMAL;
            }
            if (modifiedFoodHunger == i + 1) {
                return PARTIAL;
            }
            return MISSING;
        }
    }

    static abstract class EmptyText
    implements class_2561 {
        static List<class_2561> emptySiblings = new ArrayList<class_2561>();

        EmptyText() {
        }

        public class_2583 method_10866() {
            return class_2583.field_24360;
        }

        public class_7417 method_10851() {
            return class_8828.field_46625;
        }

        public List<class_2561> method_10855() {
            return emptySiblings;
        }
    }
}

