/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.mixin;

import com.mojang.datafixers.util.Pair;
import com.supermartijn642.formations.Formations;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import com.supermartijn642.formations.structure.processors.WaterloggingProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_9822;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3499.class})
public class StructureTemplateMixin {
    @Inject(method={"placeInWorld(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Lnet/minecraft/util/RandomSource;I)Z"}, at={@At(value="HEAD")})
    private void placeInWorld(class_5425 level, class_2338 structurePosition, class_2338 piecePosition, class_3492 placeSettings, class_5819 random, int setBlockFlags, CallbackInfoReturnable<Boolean> ci) {
        for (class_3491 processor : placeSettings.method_16182()) {
            if (!(processor instanceof WaterloggingProcessor)) continue;
            placeSettings.method_61020(class_9822.field_52237);
            return;
        }
    }

    @ModifyVariable(method={"processBlockInfos"}, at=@At(value="HEAD"), ordinal=0)
    private static List<class_3499.class_3501> processBlockInfos(List<class_3499.class_3501> blocks, class_5425 level, class_2338 piecePosition, class_2338 structurePosition, class_3492 placeSettings) {
        ArrayList<FormationsStructureProcessor> processors = null;
        for (class_3491 processor : placeSettings.method_16182()) {
            if (!(processor instanceof FormationsStructureProcessor)) continue;
            if (processors == null) {
                processors = new ArrayList<FormationsStructureProcessor>();
            }
            processors.add((FormationsStructureProcessor)processor);
        }
        if (processors == null) {
            return blocks;
        }
        HashMap<class_2338, Pair> blocksByPosition = new HashMap<class_2338, Pair>(blocks.size());
        Map<class_2338, BlockInstance> blockView = new HashMap(blocks.size());
        for (class_3499.class_3501 block : blocks) {
            class_2338 realPosition = class_3499.method_15171((class_3492)placeSettings, (class_2338)block.comp_1341()).method_10081((class_2382)piecePosition);
            BlockInstance blockInstance = new BlockInstance(block.comp_1342(), block.comp_1343());
            blocksByPosition.put(realPosition, Pair.of((Object)block.comp_1341(), (Object)blockInstance));
            blockView.put(realPosition, blockInstance);
        }
        blockView = Collections.unmodifiableMap(blockView);
        ArrayList<class_3499.class_3501> newBlocks = new ArrayList<class_3499.class_3501>(blocks.size());
        for (Map.Entry entry : blocksByPosition.entrySet()) {
            class_2338 pos = (class_2338)entry.getKey();
            BlockInstance block = (BlockInstance)((Pair)entry.getValue()).getSecond();
            for (FormationsStructureProcessor processor : processors) {
                try {
                    BlockInstance newBlock = processor.processBlock(block, pos, (class_4538)level, piecePosition, structurePosition, placeSettings, blockView);
                    if (newBlock == null) {
                        throw new NullPointerException("Processor returned null!");
                    }
                    block = newBlock;
                }
                catch (Exception e) {
                    Formations.LOGGER.error("Encountered an exception whilst processing block '{}' with processor of class '{}'!", new Object[]{block, processor.getClass(), e});
                }
            }
            if (block.state() == null) continue;
            newBlocks.add(new class_3499.class_3501((class_2338)((Pair)entry.getValue()).getFirst(), block.state(), block.nbt()));
        }
        return newBlocks;
    }
}

