/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3341;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class BiomeReplacementProcessor
extends class_3491
implements FormationsStructureProcessor {
    public static final MapCodec<BiomeReplacementProcessor> CODEC = MapCodec.unit(BiomeReplacementProcessor::new);
    private static final Map<class_5321<class_1959>, Map<class_2248, class_2248>> BIOME_REPLACEMENT_MAP = new HashMap<class_5321<class_1959>, Map<class_2248, class_2248>>();
    private static final Map<class_5321<class_1959>, Map<class_2248, class_2248>> BIOME_SOIL_REPLACEMENT_MAP = new HashMap<class_5321<class_1959>, Map<class_2248, class_2248>>();
    private static final Set<class_2248> REPLACEABLE_BLOCKS = new HashSet<class_2248>();

    @SafeVarargs
    private static void addReplacements(Pair<class_2248, List<class_5321<class_1959>>> ... entries) {
        for (int i = 0; i < entries.length; ++i) {
            Pair<class_2248, List<class_5321<class_1959>>> entry = entries[i];
            for (class_5321 biome : (List)entry.getSecond()) {
                BIOME_REPLACEMENT_MAP.computeIfAbsent((class_5321<class_1959>)biome, o -> new HashMap());
                REPLACEABLE_BLOCKS.add((class_2248)entry.getFirst());
                for (int j = 0; j < entries.length; ++j) {
                    if (i == j || entries[j].getFirst() == entry.getFirst() || entries[j].getFirst() == null) continue;
                    BIOME_REPLACEMENT_MAP.get(biome).put((class_2248)entries[j].getFirst(), (class_2248)entry.getFirst());
                }
            }
        }
    }

    @SafeVarargs
    private static void addSoilReplacements(Pair<class_2248, List<class_5321<class_1959>>> ... entries) {
        for (int i = 0; i < entries.length; ++i) {
            Pair<class_2248, List<class_5321<class_1959>>> entry = entries[i];
            for (class_5321 biome : (List)entry.getSecond()) {
                BIOME_SOIL_REPLACEMENT_MAP.computeIfAbsent((class_5321<class_1959>)biome, o -> new HashMap());
                REPLACEABLE_BLOCKS.add((class_2248)entry.getFirst());
                for (int j = 0; j < entries.length; ++j) {
                    if (i == j || entries[j].getFirst() == entry.getFirst() || entries[j].getFirst() == null) continue;
                    BIOME_SOIL_REPLACEMENT_MAP.get(biome).put((class_2248)entries[j].getFirst(), (class_2248)entry.getFirst());
                }
            }
        }
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, class_2338 pos, class_4538 level, class_2338 piecePosition, class_2338 structurePosition, class_3492 placeSettings, Map<class_2338, BlockInstance> pieceBlocks) {
        class_2680 newState;
        BlockInstance blockAbove;
        class_2680 originalState = block.state();
        if (originalState == null || originalState.method_27852(class_2246.field_10124) || !REPLACEABLE_BLOCKS.contains(originalState.method_26204())) {
            return block;
        }
        class_3341 boundingBox = placeSettings.method_15124();
        if (boundingBox == null) {
            return block;
        }
        class_6880 biomeHolder = level.method_23753(structurePosition);
        if (!biomeHolder.method_40227()) {
            return block;
        }
        class_5321 biome = (class_5321)biomeHolder.method_40230().get();
        Map<class_2248, class_2248> replacements = BIOME_SOIL_REPLACEMENT_MAP.get(biome);
        if (!(replacements != null && replacements.containsKey(originalState.method_26204()) && !((blockAbove = pieceBlocks.get(pos.method_10084())) != null && blockAbove.state() != null ? blockAbove.state() : level.method_8320(pos.method_10084())).method_26206((class_1922)level, pos.method_10084(), class_2350.field_11033) || (replacements = BIOME_REPLACEMENT_MAP.get(biome)) != null && replacements.containsKey(originalState.method_26204()))) {
            return block;
        }
        return new BlockInstance(newState, (newState = replacements.get(originalState.method_26204()).method_34725(originalState)).method_27852(block.state().method_26204()) ? block.nbt() : null);
    }

    protected class_3828<?> method_16772() {
        return FormationsStructures.BIOME_REPLACEMENT_PROCESSOR;
    }

    static {
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10161, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_9975, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37577, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10148, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10075, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10218, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10334, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_40294, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42751, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22126, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22127, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10563, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10569, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37561, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10408, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10616, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10256, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10122, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_40287, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42744, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22098, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22099, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10119, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10071, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37564, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10257, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10500, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10031, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10617, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_40292, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42746, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22128, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22129, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10431, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10037, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37545, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10511, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10010, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10533, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10306, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_41072, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42729, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22118, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22111, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10126, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10155, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37549, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10307, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10178, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_9999, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10303, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_41072, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42733, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22505, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22503, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10519, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10436, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37548, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10366, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10244, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10622, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10254, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_41073, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42732, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22119, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22112, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10250, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10558, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37550, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10204, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10374, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10103, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10084, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_41073, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42730, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22506, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22504, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10503, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_9988, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37551, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10539, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10035, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10098, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10335, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440)), Pair.of((Object)class_2246.field_42731, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_10541, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22115, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10149, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10521, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37566, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10352, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10403, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10232, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10627, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_40291, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42748, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22102, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22103, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10137, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10323, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37555, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10486, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10246, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10608, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10017, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_40285, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42740, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22094, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22095, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10121, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10411, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37554, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10231, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10330, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10284, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10544, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_40277, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42735, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22104, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22105, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10187, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10088, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37552, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10391, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10265, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10401, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10587, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_40261, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42736, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22106, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22107, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_40262, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_40263, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_40270, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_40264, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_40267, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_40265, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_40266, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_40271, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42738, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_40268, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_40269, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_40272, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_40273, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_40280, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_40274, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_40279, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_40275, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_40278, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_40283, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42739, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_40281, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_40282, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10620, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10020, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37565, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10299, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10132, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10144, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10319, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_40290, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42747, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22132, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22133, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10188, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10291, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37563, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10513, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10196, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10457, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10041, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_40289, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42745, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22096, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22097, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10484, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10332, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37553, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10592, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10470, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10397, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10026, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_40284, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42737, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22130, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22131, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10057, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10066, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37559, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10417, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10493, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10278, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443, class_1972.field_9424)), Pair.of((Object)class_2246.field_10553, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_40286, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42743, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22100, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22101, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10394, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_35110, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_37543)), Pair.of((Object)class_2246.field_10217, List.of(class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418)), Pair.of((Object)class_2246.field_37544, List.of(class_1972.field_9471, class_1972.field_38748)), Pair.of((Object)class_2246.field_10575, List.of(class_1972.field_9412, class_1972.field_35112, class_1972.field_9438)), Pair.of((Object)class_2246.field_10160, List.of(class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470)), Pair.of((Object)class_2246.field_10385, List.of(class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9415, class_1972.field_9443)), Pair.of((Object)class_2246.field_10428, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10276, List.of(class_1972.field_9417, class_1972.field_35118, class_1972.field_29218)), Pair.of((Object)class_2246.field_10108, List.of(class_1972.field_9440)), Pair.of((Object)class_2246.field_42727, List.of(class_1972.field_42720)), Pair.of((Object)class_2246.field_22121, List.of(class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_22114, List.of(class_1972.field_22075, class_1972.field_22076, class_1972.field_23859, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10552, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720)), Pair.of((Object)class_2246.field_10292, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10117, List.of(class_1972.field_35110, class_1972.field_9415, class_1972.field_9443)), Pair.of((Object)class_2246.field_28904, List.of(class_1972.field_37543)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10416, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720)), Pair.of((Object)class_2246.field_10467, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10483, List.of(class_1972.field_35110, class_1972.field_9415, class_1972.field_9443)), Pair.of((Object)class_2246.field_29222, List.of(class_1972.field_37543)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10056, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720)), Pair.of((Object)class_2246.field_9979, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10344, List.of(class_1972.field_35110, class_1972.field_9415, class_1972.field_9443)), Pair.of((Object)class_2246.field_28900, List.of(class_1972.field_37543)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10392, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720)), Pair.of((Object)class_2246.field_10142, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10420, List.of(class_1972.field_35110, class_1972.field_9415, class_1972.field_9443)), Pair.of((Object)class_2246.field_28901, List.of(class_1972.field_37543)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10131, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720)), Pair.of((Object)class_2246.field_10007, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10624, List.of(class_1972.field_35110, class_1972.field_9415, class_1972.field_9443)), Pair.of((Object)class_2246.field_28902, List.of(class_1972.field_37543)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10252, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720)), Pair.of((Object)class_2246.field_10630, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10413, List.of(class_1972.field_35110, class_1972.field_9415, class_1972.field_9443)), Pair.of((Object)class_2246.field_28903, List.of(class_1972.field_37543)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10360, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720)), Pair.of((Object)class_2246.field_10361, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10518, List.of(class_1972.field_35110, class_1972.field_9415, class_1972.field_9443)), Pair.of((Object)class_2246.field_28892, List.of(class_1972.field_37543)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10136, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720)), Pair.of((Object)class_2246.field_18890, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_18891, List.of(class_1972.field_35110, class_1972.field_9415, class_1972.field_9443)), Pair.of((Object)class_2246.field_28894, List.of(class_1972.field_37543)));
        BiomeReplacementProcessor.addSoilReplacements(Pair.of((Object)class_2246.field_10219, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543)), Pair.of((Object)class_2246.field_10102, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10534, List.of(class_1972.field_9415, class_1972.field_9443)), Pair.of((Object)class_2246.field_22091, List.of(class_1972.field_23859)), Pair.of((Object)class_2246.field_22090, List.of(class_1972.field_22076)), Pair.of((Object)class_2246.field_10515, List.of(class_1972.field_9461)), Pair.of((Object)class_2246.field_22120, List.of(class_1972.field_22077)), Pair.of((Object)class_2246.field_22113, List.of(class_1972.field_22075)), Pair.of((Object)class_2246.field_10471, List.of(class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10194, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9424, class_1972.field_9415, class_1972.field_9443)), Pair.of((Object)class_2246.field_10114, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461, class_1972.field_22077, class_1972.field_22075)), Pair.of((Object)class_2246.field_10471, List.of(class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10566, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_37543)), Pair.of((Object)class_2246.field_10102, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10415, List.of(class_1972.field_9415, class_1972.field_9443, class_1972.field_35110)), Pair.of((Object)class_2246.field_22091, List.of(class_1972.field_23859)), Pair.of((Object)class_2246.field_22090, List.of(class_1972.field_22076)), Pair.of((Object)class_2246.field_10515, List.of(class_1972.field_9461, class_1972.field_22077, class_1972.field_22075)), Pair.of((Object)class_2246.field_10471, List.of(class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10340, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_37543, class_1972.field_9424)), Pair.of((Object)class_2246.field_10415, List.of(class_1972.field_9415, class_1972.field_9443, class_1972.field_35110)), Pair.of((Object)class_2246.field_22091, List.of(class_1972.field_23859)), Pair.of((Object)class_2246.field_10515, List.of(class_1972.field_22076, class_1972.field_9461, class_1972.field_22077, class_1972.field_22075)), Pair.of((Object)class_2246.field_10471, List.of(class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10479, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_9424)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_23859, class_1972.field_9461, class_1972.field_22076)), Pair.of((Object)class_2246.field_22125, List.of(class_1972.field_22077)), Pair.of((Object)class_2246.field_22116, List.of(class_1972.field_22075)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10479, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10428, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461, class_1972.field_22077)), Pair.of((Object)class_2246.field_23079, List.of(class_1972.field_22075)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10182, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10559, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461)), Pair.of((Object)class_2246.field_22121, List.of(class_1972.field_22077)), Pair.of((Object)class_2246.field_22114, List.of(class_1972.field_22075)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10449, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10251, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461)), Pair.of((Object)class_2246.field_22121, List.of(class_1972.field_22077)), Pair.of((Object)class_2246.field_22114, List.of(class_1972.field_22075)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10086, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10559, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461)), Pair.of((Object)class_2246.field_22121, List.of(class_1972.field_22077)), Pair.of((Object)class_2246.field_22114, List.of(class_1972.field_22075)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10226, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10559, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461)), Pair.of((Object)class_2246.field_22121, List.of(class_1972.field_22077)), Pair.of((Object)class_2246.field_22114, List.of(class_1972.field_22075)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10573, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10559, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461)), Pair.of((Object)class_2246.field_22121, List.of(class_1972.field_22077)), Pair.of((Object)class_2246.field_22114, List.of(class_1972.field_22075)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10270, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10559, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461)), Pair.of((Object)class_2246.field_22121, List.of(class_1972.field_22077)), Pair.of((Object)class_2246.field_22114, List.of(class_1972.field_22075)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10048, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_9424, class_1972.field_22077, class_1972.field_22075)), Pair.of((Object)class_2246.field_10251, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10156, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10559, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461)), Pair.of((Object)class_2246.field_22121, List.of(class_1972.field_22077)), Pair.of((Object)class_2246.field_22114, List.of(class_1972.field_22075)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10315, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10559, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461)), Pair.of((Object)class_2246.field_22121, List.of(class_1972.field_22077)), Pair.of((Object)class_2246.field_22114, List.of(class_1972.field_22075)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10554, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10559, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461)), Pair.of((Object)class_2246.field_22121, List.of(class_1972.field_22077)), Pair.of((Object)class_2246.field_22114, List.of(class_1972.field_22075)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_9995, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10559, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461)), Pair.of((Object)class_2246.field_22121, List.of(class_1972.field_22077)), Pair.of((Object)class_2246.field_22114, List.of(class_1972.field_22075)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)class_2246.field_10548, List.of(class_1972.field_9451, class_1972.field_9455, class_1972.field_9409, class_1972.field_9414, class_1972.field_35116, class_1972.field_35111, class_1972.field_35120, class_1972.field_34470, class_1972.field_9434, class_1972.field_9419, class_1972.field_28107, class_1972.field_35117, class_1972.field_9453, class_1972.field_35119, class_1972.field_35113, class_1972.field_9420, class_1972.field_9454, class_1972.field_34471, class_1972.field_34472, class_1972.field_35115, class_1972.field_34474, class_1972.field_34475, class_1972.field_9463, class_1972.field_9478, class_1972.field_9435, class_1972.field_9418, class_1972.field_9471, class_1972.field_38748, class_1972.field_9412, class_1972.field_35112, class_1972.field_9438, class_1972.field_9475, class_1972.field_9408, class_1972.field_9441, class_1972.field_9439, class_1972.field_9423, class_1972.field_9446, class_1972.field_9467, class_1972.field_9470, class_1972.field_9449, class_1972.field_9430, class_1972.field_35114, class_1972.field_9417, class_1972.field_35118, class_1972.field_29218, class_1972.field_9440, class_1972.field_42720, class_1972.field_35110, class_1972.field_37543, class_1972.field_9415, class_1972.field_9443, class_1972.field_9411, class_1972.field_9442, class_1972.field_9447, class_1972.field_9457, class_1972.field_9465)), Pair.of((Object)class_2246.field_10124, List.of(class_1972.field_9424)), Pair.of((Object)class_2246.field_10559, List.of(class_1972.field_22076, class_1972.field_23859, class_1972.field_9461)), Pair.of((Object)class_2246.field_22121, List.of(class_1972.field_22077)), Pair.of((Object)class_2246.field_22114, List.of(class_1972.field_22075)));
    }
}

