/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.command;

import com.mojang.authlib.GameProfile;
import java.util.TreeSet;
import journeymap.api.services.EventBus;
import journeymap.api.v2.common.event.common.TeleportEvent;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.JourneymapClient;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1132;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3324;
import net.minecraft.class_5268;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class CmdTeleportWaypoint {
    final class_310 mc = class_310.method_1551();
    final ClientWaypointImpl waypoint;

    public CmdTeleportWaypoint(ClientWaypointImpl waypoint) {
        this.waypoint = waypoint;
    }

    public static boolean isPermitted(class_310 mc) {
        if (mc.method_1576() != null) {
            class_1132 mcServer = mc.method_1576();
            class_3324 configurationManager = null;
            GameProfile profile = null;
            try {
                profile = new GameProfile(mc.field_1724.method_5667(), mc.field_1724.method_5477().getString());
                configurationManager = mcServer.method_3760();
                Journeymap.getLogger().debug("integrated server not null, can send commands: " + configurationManager.method_14569(profile) + " is tp enabled: " + JourneymapClient.getInstance().getStateHandler().isTeleportEnabled());
                return configurationManager.method_14569(profile) || JourneymapClient.getInstance().getStateHandler().isTeleportEnabled();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (profile != null && configurationManager != null) {
                        Journeymap.getLogger().debug("Some Error happened: " + mcServer.method_3724() + " : " + ((class_5268)mcServer.method_3847(mc.field_1724.method_37908().method_27983()).method_8401()).method_194() + " : " + mcServer.method_43824().getName().equalsIgnoreCase(profile.getName()));
                        return mcServer.method_3724() && ((class_5268)mcServer.method_3847(mc.field_1724.method_37908().method_27983()).method_8401()).method_194() && mcServer.method_43824().getName().equalsIgnoreCase(profile.getName());
                    }
                    Journeymap.getLogger().warn("Failed to check teleport permission both ways: " + LogFormatter.toString(e) + ", and profile or configManager were null.");
                }
                catch (Exception e2) {
                    Journeymap.getLogger().warn("Failed to check teleport permission. Both ways failed: " + LogFormatter.toString(e) + ", and " + LogFormatter.toString(e2));
                }
            }
        }
        if (JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection()) {
            Journeymap.getLogger().debug("On a server with JM returning: " + JourneymapClient.getInstance().getStateHandler().isTeleportEnabled());
            return JourneymapClient.getInstance().getStateHandler().isTeleportEnabled();
        }
        Journeymap.getLogger().debug("On a server without JM returning true by default");
        return true;
    }

    public void run() {
        TeleportEvent event;
        double z;
        double x;
        if (JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection() || class_310.method_1551().method_1496()) {
            x = this.waypoint.getRawCenterX();
            z = this.waypoint.getRawCenterZ();
        } else {
            x = this.waypoint.getBlockCenteredX();
            z = this.waypoint.getBlockCenteredZ();
        }
        TreeSet<String> dims = this.waypoint.getDimensions();
        String dim = this.mc.field_1724.method_37908().method_27983().method_29177().toString();
        if (!dims.isEmpty() && !dims.contains(dim = this.waypoint.getPos().getPrimaryDimension())) {
            dim = dims.stream().filter(d -> this.mc.field_1724.method_37908().method_27983().equals(DimensionHelper.getWorldKeyForName(d))).findFirst().orElse(dims.first());
        }
        if (class_1937.field_25180.equals(DimensionHelper.getWorldKeyForName(dim)) && class_1937.field_25180.equals(this.mc.field_1724.method_37908().method_27983())) {
            x = this.waypoint.getRawCenterX();
            z = this.waypoint.getRawCenterZ();
        }
        if (!EventBus.post(event = new TeleportEvent((Waypoint)this.waypoint, class_2338.method_49637((double)x, (double)this.waypoint.getY(), (double)z), this.mc.field_1724.method_37908().method_27983(), DimensionHelper.getWorldKeyForName(dim))).isCancelled()) {
            class_243 pos = class_243.method_26410((class_2382)event.getPos(), (double)0.0);
            CmdTeleportWaypoint.teleport(pos.method_10216(), (int)pos.method_10214(), pos.method_10215(), event.getDestinationLevel().method_29177().toString(), this.waypoint.getName());
        }
    }

    public static void teleport(class_2338 pos, class_5321<class_1937> dim, @Nullable String name) {
        TeleportEvent event = new TeleportEvent(pos, dim);
        if (!EventBus.post(event).isCancelled()) {
            class_5321 dimension = event.getDestinationLevel();
            CmdTeleportWaypoint.teleport(event.getPos().method_10263(), event.getPos().method_10264(), event.getPos().method_10260(), dimension != null ? dimension.method_29177().toString() : null, name);
        }
    }

    public static void teleport(double x, int y, double z, String dim, @Nullable String name) {
        class_310 mc = class_310.method_1551();
        if (JourneymapClient.getInstance().getStateHandler().isJourneyMapServerConnection() || class_310.method_1551().method_1496()) {
            JourneymapClient.getInstance().getDispatcher().sendTeleportPacket(x, y, z, dim);
        } else {
            String teleportCommand = JourneymapClient.getInstance().getWaypointProperties().teleportCommand.getAsString();
            Boolean wholeNumbers = JourneymapClient.getInstance().getWaypointProperties().wholeNumberTeleportCoords.get();
            String xLoc = wholeNumbers != false ? Integer.toString((int)x) : String.valueOf(x);
            String zLoc = wholeNumbers != false ? Integer.toString((int)z) : String.valueOf(z);
            if ((teleportCommand = teleportCommand.replace("{name}", mc.field_1724.method_5477().getString()).replace("{x}", xLoc).replace("{y}", String.valueOf(y)).replace("{z}", zLoc).replace("{wpname}", name != null ? name : "").replace("{dim}", dim)).startsWith("/")) {
                Journeymap.getLogger().debug("Sending slash tp command: {}", (Object)teleportCommand);
                mc.field_1724.field_3944.method_45730(teleportCommand.substring(1));
            } else {
                Journeymap.getLogger().debug("Sending non-slash tp command: {}", (Object)teleportCommand);
                mc.field_1724.field_3944.method_45729(teleportCommand);
            }
        }
    }
}

