/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.dropdown;

import java.util.List;
import java.util.Optional;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.Removable;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.ImageDropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.client.ui.component.screens.ScrollPaneScreen;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class DropDownButton
extends Button
implements Removable,
SelectableParent {
    private static final int MAX_DISPLAY_SIZE = 6;
    protected boolean visible = false;
    protected DropDownItem selected;
    protected List<DropDownItem> items;
    protected int paneWidth;
    protected class_4185.class_4241 onPress;
    protected int rotation = 0;
    protected class_2960 glyph = TextureCache.ARROW_GLYPH;
    protected int panelMargin = 2;
    protected ScrollPaneScreen paneScreen;
    protected int buttonBuffer = 50;
    protected int hgap = 5;
    protected boolean scaleButtonWidth = true;
    protected boolean renderSolidBackground = false;

    public DropDownButton(String label, class_4185.class_4241 onPress) {
        super(label, DropDownButton.emptyPressable());
        this.onPress = onPress;
    }

    public void setItems(List<DropDownItem> items) {
        this.items = items;
        this.paneWidth = this.method_25368();
        this.paneScreen = new ScrollPaneScreen(this, items, this.paneWidth, this.getPaneHeight(), this.method_46426(), this.getPanelLocation());
        this.paneScreen.setRenderSolidBackground(this.renderSolidBackground);
    }

    public void setRenderSolidBackground(boolean value) {
        this.renderSolidBackground = value;
        if (this.paneScreen != null) {
            this.paneScreen.setRenderSolidBackground(value);
        }
    }

    public void setRenderDecorations(boolean value) {
        this.paneScreen.setRenderDecorations(value);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean buttonClicked = super.method_25402(mouseX, mouseY, button);
        if (buttonClicked && !this.visible) {
            this.openDropDown();
            return true;
        }
        return buttonClicked;
    }

    protected void openDropDown() {
        if (!this.visible) {
            this.visible = true;
            this.setEnabled(false);
            this.paneScreen.setPaneX(this.method_46426());
            this.paneScreen.setPaneY(this.getPanelLocation());
            this.paneScreen.display();
        }
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_48579(graphics, mouseX, mouseY, partialTicks);
        int imageX = this.method_46426() + 5;
        if (this.horizontalAlignment == DrawUtil.HAlign.Left) {
            imageX = this.getRightX() - this.WIDTH_PAD / 2 - this.fontRenderer.method_1727(this.method_25369().getString()) - 10;
        }
        DrawUtil.drawClampedTexture(graphics, this.glyph, this.getLabelColor(), this.visible ? 0.8f : 1.0f, imageX, (float)this.getMiddleY() - 4.0f, 32.0, 32.0, 0.25f, this.visible ? (double)this.rotation : 0.0);
        DropDownItem dropDownItem = this.selected;
        if (dropDownItem instanceof ImageDropDownItem) {
            ImageDropDownItem item = (ImageDropDownItem)dropDownItem;
            item.renderImage(graphics, this.getCenterX(), this.method_46427() + (this.field_22759 >> 1) - (item.method_25364() >> 1));
        }
    }

    protected int getPanelLocation() {
        class_1041 window = class_310.method_1551().method_22683();
        int panelHeight = this.getPaneHeight();
        int windowBottom = window.method_4502();
        if (super.method_46427() - (this.panelMargin + panelHeight) <= 0) {
            this.rotation = 90;
            return super.method_46427() + this.panelMargin + this.field_22759;
        }
        if (super.method_46427() + (this.panelMargin + panelHeight) > windowBottom) {
            this.rotation = -90;
            return super.method_46427() - panelHeight - this.panelMargin;
        }
        this.rotation = 90;
        return super.method_46427() + this.panelMargin + this.field_22759;
    }

    protected int getPaneHeight() {
        int size = Math.min(this.items.size(), 6);
        return size * (this.items.get(0).method_25364() + 5);
    }

    @Override
    public void onRemove() {
        this.visible = false;
        this.setEnabled(true);
    }

    public int method_25368() {
        int width = 0;
        if (this.items != null) {
            class_327 fontRenderer = class_310.method_1551().field_1772;
            for (DropDownItem item : this.items) {
                width = Math.max(width, fontRenderer.method_1727(this.getLabel(item)));
            }
            if (!this.scaleButtonWidth) {
                return width + this.buttonBuffer;
            }
            this.field_22758 = width + this.buttonBuffer;
        }
        return this.field_22758;
    }

    public int method_25364() {
        return this.field_22759;
    }

    protected String getLabel(DropDownItem item) {
        return item.getLabel();
    }

    @Override
    public void setSelected(DropDownItem selected) {
        this.selected = selected;
        this.onPress.onPress((class_4185)selected);
        this.method_25355((class_2561)class_2561.method_43470((String)selected.getLabel()));
    }

    public void setSelectedId(String id) {
        Optional<DropDownItem> select = this.items.stream().filter(item -> item.getId().toString().equals(id)).findFirst();
        if (select.isPresent()) {
            this.selected = select.get();
            this.method_25355((class_2561)class_2561.method_43470((String)this.selected.getLabel()));
        }
    }

    public DropDownItem getSelected() {
        return this.selected;
    }

    protected String getSelectedLabel() {
        return this.getLabel(this.selected);
    }

    public void setButtonBuffer(int buttonBuffer) {
        this.buttonBuffer = buttonBuffer;
    }
}

