/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3917;
import net.minecraft.class_7225;

public class BackpackItemMenu
extends BackpackBaseMenu {
    public BackpackItemMenu(int windowID, class_1661 playerInventory, ModScreenHandlerTypes.ItemScreenData data) {
        this(windowID, playerInventory, BackpackItemMenu.createWrapper(playerInventory, data));
    }

    public BackpackItemMenu(int windowID, class_1661 playerInventory, BackpackWrapper wrapper) {
        super((class_3917<?>)ModScreenHandlerTypes.BACKPACK_MENU, windowID, playerInventory, wrapper);
        this.wrapper.addUser(playerInventory.field_7546);
    }

    private static BackpackWrapper createWrapper(class_1661 inventory, ModScreenHandlerTypes.ItemScreenData data) {
        Objects.requireNonNull(inventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        int screenID = data.screenID();
        int entityId = data.entityID();
        if (screenID == 2) {
            if (entityId != -1) {
                BackpackWrapper targetWrapper = ComponentUtils.getBackpackWrapper((class_1657)inventory.field_7546.method_37908().method_8469(entityId));
                targetWrapper.addUser(inventory.field_7546);
                return targetWrapper;
            }
            return ComponentUtils.getBackpackWrapper(inventory.field_7546);
        }
        class_1799 backpackStack = entityId == -1 ? inventory.field_7546.method_5998(class_1268.field_5808) : (class_1799)inventory.method_67533().get(entityId);
        return new BackpackWrapper(backpackStack, screenID, (class_7225.class_7874)inventory.field_7546.method_56673(), inventory.field_7546, inventory.field_7546.method_37908(), entityId);
    }

    public void method_7593(int slotId, int dragType, class_1713 clickType, class_1657 player) {
        if (this.getWrapper().getScreenID() == 1 && clickType == class_1713.field_7791) {
            class_1799 stack = player.method_31548().method_5438(dragType);
            class_1799 currentItem = player.method_31548().method_7391();
            if (!currentItem.method_7960() && stack == currentItem) {
                return;
            }
        }
        super.method_7593(slotId, dragType, clickType, player);
    }

    @Override
    public void addPlayerInventoryAndHotbar(class_1661 inventory, int currentItemIndex) {
        int modifiedOffset = this.extendedScreenOffset;
        if (this.wrapper.isExtended()) {
            modifiedOffset += 18;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                if (x + y * 9 + 9 == currentItemIndex) {
                    this.method_7621(new DisabledSlot((class_1263)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 25 + y * 18));
                    this.disabledSlotIndex = this.field_7761.size() - 1;
                    continue;
                }
                this.method_7621(new class_1735((class_1263)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 25 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            if (x == currentItemIndex && this.wrapper.getScreenID() == 1) {
                this.method_7621(new DisabledSlot((class_1263)inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 83));
                this.disabledSlotIndex = this.field_7761.size() - 1;
                continue;
            }
            this.method_7621(new class_1735((class_1263)inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 83));
        }
    }

    @Override
    public void method_7595(class_1657 player) {
        if (player.field_7512 instanceof BackpackBaseMenu && player.method_37908().field_9236) {
            return;
        }
        this.wrapper.playersUsing.remove(player);
        super.method_7595(player);
    }

    @Override
    public boolean method_7597(class_1657 player) {
        if (this.getWrapper().getBackpackOwner() != null) {
            return this.getWrapper().getBackpackOwner().method_5805() && ComponentUtils.isWearingBackpack(this.getWrapper().getBackpackOwner());
        }
        if (this.getWrapper().getScreenID() == 1) {
            class_1799 backpackStack = this.getWrapper().getBackpackSlotIndex() == -1 ? player.method_5998(class_1268.field_5808) : this.inventory.method_5438(this.getWrapper().getBackpackSlotIndex());
            return backpackStack.method_7909() instanceof TravelersBackpackItem;
        }
        return true;
    }
}

