/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.hotkeys;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.class_3542;

public class KeybindSettings {
    public static final Codec<KeybindSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Context.CODEC.fieldOf("context").forGetter(get -> get.context), (App)KeyAction.CODEC.fieldOf("activateOn").forGetter(get -> get.activateOn), (App)Codec.BOOL.fieldOf("allowExtraKeys").forGetter(get -> get.allowExtraKeys), (App)Codec.BOOL.fieldOf("orderSensitive").forGetter(get -> get.orderSensitive), (App)Codec.BOOL.fieldOf("exclusive").forGetter(get -> get.exclusive), (App)Codec.BOOL.fieldOf("cancel").forGetter(get -> get.cancel), (App)Codec.BOOL.optionalFieldOf("allowEmpty", (Object)false).forGetter(get -> get.allowEmpty)).apply((Applicative)instance, KeybindSettings::new));
    public static final KeybindSettings DEFAULT = new KeybindSettings(Context.INGAME, KeyAction.PRESS, false, true, false, true);
    public static final KeybindSettings EXCLUSIVE = new KeybindSettings(Context.INGAME, KeyAction.PRESS, false, true, true, true);
    public static final KeybindSettings RELEASE = new KeybindSettings(Context.INGAME, KeyAction.RELEASE, false, true, false, false);
    public static final KeybindSettings RELEASE_ALLOW_EXTRA = new KeybindSettings(Context.INGAME, KeyAction.RELEASE, true, true, false, false);
    public static final KeybindSettings RELEASE_EXCLUSIVE = new KeybindSettings(Context.INGAME, KeyAction.RELEASE, false, true, true, true);
    public static final KeybindSettings NOCANCEL = new KeybindSettings(Context.INGAME, KeyAction.PRESS, false, true, false, false);
    public static final KeybindSettings PRESS_ALLOWEXTRA = new KeybindSettings(Context.INGAME, KeyAction.PRESS, true, true, false, true);
    public static final KeybindSettings PRESS_ALLOWEXTRA_EMPTY = new KeybindSettings(Context.INGAME, KeyAction.PRESS, true, true, false, true, true);
    public static final KeybindSettings PRESS_NON_ORDER_SENSITIVE = new KeybindSettings(Context.INGAME, KeyAction.PRESS, false, false, false, true);
    public static final KeybindSettings INGAME_BOTH = new KeybindSettings(Context.INGAME, KeyAction.BOTH, false, true, false, true);
    public static final KeybindSettings MODIFIER_INGAME = new KeybindSettings(Context.INGAME, KeyAction.PRESS, true, false, false, false);
    public static final KeybindSettings MODIFIER_INGAME_EMPTY = new KeybindSettings(Context.INGAME, KeyAction.PRESS, true, false, false, false, true);
    public static final KeybindSettings MODIFIER_GUI = new KeybindSettings(Context.GUI, KeyAction.PRESS, true, false, false, false);
    public static final KeybindSettings GUI = new KeybindSettings(Context.GUI, KeyAction.PRESS, false, true, false, true);
    private final Context context;
    private final KeyAction activateOn;
    private final boolean allowEmpty;
    private final boolean allowExtraKeys;
    private final boolean orderSensitive;
    private final boolean exclusive;
    private final boolean cancel;

    private KeybindSettings(Context context, KeyAction activateOn, boolean allowExtraKeys, boolean orderSensitive, boolean exclusive, boolean cancel) {
        this(context, activateOn, allowExtraKeys, orderSensitive, exclusive, cancel, false);
    }

    private KeybindSettings(Context context, KeyAction activateOn, boolean allowExtraKeys, boolean orderSensitive, boolean exclusive, boolean cancel, boolean allowEmpty) {
        this.context = context;
        this.activateOn = activateOn;
        this.allowExtraKeys = allowExtraKeys;
        this.orderSensitive = orderSensitive;
        this.exclusive = exclusive;
        this.cancel = cancel;
        this.allowEmpty = allowEmpty;
    }

    public static KeybindSettings create(Context context, KeyAction activateOn, boolean allowExtraKeys, boolean orderSensitive, boolean exclusive, boolean cancel) {
        return KeybindSettings.create(context, activateOn, allowExtraKeys, orderSensitive, exclusive, cancel, false);
    }

    public static KeybindSettings create(Context context, KeyAction activateOn, boolean allowExtraKeys, boolean orderSensitive, boolean exclusive, boolean cancel, boolean allowEmpty) {
        return new KeybindSettings(context, activateOn, allowExtraKeys, orderSensitive, exclusive, cancel, allowEmpty);
    }

    public Context getContext() {
        return this.context;
    }

    public KeyAction getActivateOn() {
        return this.activateOn;
    }

    public boolean getAllowEmpty() {
        return this.allowEmpty;
    }

    public boolean getAllowExtraKeys() {
        return this.allowExtraKeys;
    }

    public boolean isOrderSensitive() {
        return this.orderSensitive;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean shouldCancel() {
        return this.cancel;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("activate_on", this.activateOn.name());
        obj.addProperty("context", this.context.name());
        obj.addProperty("allow_empty", Boolean.valueOf(this.allowEmpty));
        obj.addProperty("allow_extra_keys", Boolean.valueOf(this.allowExtraKeys));
        obj.addProperty("order_sensitive", Boolean.valueOf(this.orderSensitive));
        obj.addProperty("exclusive", Boolean.valueOf(this.exclusive));
        obj.addProperty("cancel", Boolean.valueOf(this.cancel));
        return obj;
    }

    public JsonObject toJsonCodec() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).resultOrPartial(err -> MaLiLib.LOGGER.warn("KeybindSettings#toJsonCodec(): Error {}", err)).orElse(new JsonObject());
    }

    @Nullable
    public static KeybindSettings fromJsonCodec(JsonObject obj) {
        Pair pair = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).resultOrPartial(err -> MaLiLib.LOGGER.warn("KeybindSettings#fromJsonCodec(): Error {}", err)).orElse(null);
        if (pair != null && pair.getFirst() != null) {
            return (KeybindSettings)pair.getFirst();
        }
        return null;
    }

    public static KeybindSettings fromJson(JsonObject obj) {
        Enum context = Context.INGAME;
        Enum activateOn = KeyAction.PRESS;
        String contextStr = JsonUtils.getString(obj, "context");
        String activateStr = JsonUtils.getString(obj, "activate_on");
        if (contextStr != null) {
            for (Enum enum_ : Context.values()) {
                if (!enum_.name().equalsIgnoreCase(contextStr)) continue;
                context = enum_;
                break;
            }
        }
        if (activateStr != null) {
            for (Enum enum_ : KeyAction.values()) {
                if (!enum_.name().equalsIgnoreCase(activateStr)) continue;
                activateOn = enum_;
                break;
            }
        }
        boolean allowEmpty = JsonUtils.getBoolean(obj, "allow_empty");
        boolean allowExtraKeys = JsonUtils.getBoolean(obj, "allow_extra_keys");
        boolean orderSensitive = JsonUtils.getBooleanOrDefault(obj, "order_sensitive", true);
        boolean bl = JsonUtils.getBooleanOrDefault(obj, "exclusive", true);
        boolean cancel = JsonUtils.getBooleanOrDefault(obj, "cancel", true);
        return KeybindSettings.create(context, activateOn, allowExtraKeys, orderSensitive, bl, cancel, allowEmpty);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeybindSettings other = (KeybindSettings)obj;
        if (this.activateOn != other.activateOn) {
            return false;
        }
        if (this.context != other.context) {
            return false;
        }
        if (this.allowEmpty != other.allowEmpty) {
            return false;
        }
        if (this.allowExtraKeys != other.allowExtraKeys) {
            return false;
        }
        if (this.cancel != other.cancel) {
            return false;
        }
        if (this.exclusive != other.exclusive) {
            return false;
        }
        return this.orderSensitive == other.orderSensitive;
    }

    public static enum Context implements IConfigOptionListEntry,
    class_3542
    {
        INGAME("ingame", "malilib.label.key_context.ingame"),
        GUI("gui", "malilib.label.key_context.gui"),
        ANY("any", "malilib.label.key_context.any");

        public static final class_3542.class_7292<Context> CODEC;
        public static final ImmutableList<Context> VALUES;
        private final String configString;
        private final String translationKey;

        private Context(String configString, String translationKey) {
            this.configString = configString;
            this.translationKey = translationKey;
        }

        public String method_15434() {
            return this.configString;
        }

        @Override
        public String getStringValue() {
            return this.configString;
        }

        @Override
        public String getDisplayName() {
            return StringUtils.translate(this.translationKey, new Object[0]);
        }

        @Override
        public IConfigOptionListEntry cycle(boolean forward) {
            int id = this.ordinal();
            if (forward) {
                if (++id >= Context.values().length) {
                    id = 0;
                }
            } else if (--id < 0) {
                id = Context.values().length - 1;
            }
            return Context.values()[id % Context.values().length];
        }

        @Override
        public Context fromString(String name) {
            return Context.fromStringStatic(name);
        }

        public static Context fromStringStatic(String name) {
            for (Context context : Context.values()) {
                if (!context.configString.equalsIgnoreCase(name)) continue;
                return context;
            }
            return INGAME;
        }

        static {
            CODEC = class_3542.method_28140(Context::values);
            VALUES = ImmutableList.copyOf((Object[])Context.values());
        }
    }
}

