/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract class BaseNbtStringifier {
    protected final String baseColor;
    protected final boolean colored;
    protected final boolean useNumberSuffix;
    protected String tagNameQuote = "\"";
    protected String keyColor;
    protected String numberColor;
    protected String numberTypeColor;
    protected String stringColor;

    public BaseNbtStringifier(boolean useNumberSuffix) {
        this(false, useNumberSuffix, "");
    }

    public BaseNbtStringifier(boolean colored, boolean useNumberSuffix, String baseColor) {
        this.colored = colored;
        this.useNumberSuffix = useNumberSuffix;
        this.baseColor = baseColor;
        this.keyColor = StringUtils.translate("malilib.label.nbt_tooltip.key_color", new Object[0]);
        this.numberColor = StringUtils.translate("malilib.label.nbt_tooltip.number_color", new Object[0]);
        this.numberTypeColor = StringUtils.translate("malilib.label.nbt_tooltip.number_type_color", new Object[0]);
        this.stringColor = StringUtils.translate("malilib.label.nbt_tooltip.string_color", new Object[0]);
    }

    protected String getFormattedTagName(String name) {
        if (name.length() == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.tagNameQuote);
        if (this.colored) {
            sb.append(this.keyColor);
            sb.append(name);
            sb.append(this.baseColor);
        } else {
            sb.append(name);
        }
        sb.append(this.tagNameQuote);
        return sb.toString();
    }

    @Nullable
    protected String getPrimitiveValue(class_2520 tag) {
        switch (tag.method_10711()) {
            case 1: {
                return String.valueOf(((class_2481)tag).method_10698());
            }
            case 2: {
                return String.valueOf(((class_2516)tag).method_10696());
            }
            case 3: {
                return String.valueOf(((class_2497)tag).method_10701());
            }
            case 4: {
                return String.valueOf(((class_2503)tag).method_10699());
            }
            case 5: {
                return String.valueOf(((class_2494)tag).method_10700());
            }
            case 6: {
                return String.valueOf(((class_2489)tag).method_10697());
            }
            case 8: {
                return ((class_2519)tag).comp_3831();
            }
        }
        return null;
    }

    @Nullable
    protected String getNumberSuffix(int tagId) {
        switch (tagId) {
            case 1: {
                return "b";
            }
            case 2: {
                return "s";
            }
            case 4: {
                return "L";
            }
            case 5: {
                return "f";
            }
            case 6: {
                return "d";
            }
        }
        return null;
    }

    @Nullable
    protected String getPrimitiveColorCode(int tagId) {
        switch (tagId) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.numberColor;
            }
            case 8: {
                return this.stringColor;
            }
        }
        return null;
    }

    protected String getFormattedPrimitiveString(class_2520 tag) {
        byte typeId = tag.method_10711();
        String valueStr = this.getPrimitiveValue(tag);
        String valueColorStr = this.colored ? this.getPrimitiveColorCode(typeId) : null;
        String numberSuffixStr = this.useNumberSuffix ? this.getNumberSuffix(typeId) : null;
        boolean useQuotes = typeId == 8;
        return this.getFormattedPrimitiveString(valueStr, useQuotes, valueColorStr, numberSuffixStr);
    }

    protected String getFormattedPrimitiveString(String valueStr, boolean useQuotes, @Nullable String valueColorStr, @Nullable String numberSuffixStr) {
        StringBuilder sb = new StringBuilder();
        if (valueStr == null) {
            return "";
        }
        if (useQuotes) {
            sb.append('\"');
        }
        if (valueColorStr != null) {
            sb.append(valueColorStr);
        }
        sb.append(valueStr);
        if (numberSuffixStr != null) {
            if (this.colored) {
                sb.append(this.numberTypeColor);
            }
            sb.append(numberSuffixStr);
        }
        if (this.colored) {
            sb.append(this.baseColor);
        }
        if (useQuotes) {
            sb.append('\"');
        }
        return sb.toString();
    }

    protected void appendTag(String tagName, class_2520 tag) {
        switch (tag.method_10711()) {
            case 10: {
                this.appendCompound(tagName, (class_2487)tag);
                break;
            }
            case 9: {
                this.appendList(tagName, (class_2499)tag);
                break;
            }
            case 7: {
                this.appendByteArray(tagName, ((class_2479)tag).method_10521());
                break;
            }
            case 11: {
                this.appendIntArray(tagName, ((class_2495)tag).method_10588());
                break;
            }
            case 12: {
                this.appendLongArray(tagName, ((class_2501)tag).method_10615());
                break;
            }
            default: {
                this.appendPrimitive(tagName, tag);
            }
        }
    }

    protected abstract void appendPrimitive(String var1, class_2520 var2);

    protected abstract void appendCompound(String var1, class_2487 var2);

    protected abstract void appendList(String var1, class_2499 var2);

    protected abstract void appendByteArray(String var1, byte[] var2);

    protected abstract void appendIntArray(String var1, int[] var2);

    protected abstract void appendLongArray(String var1, long[] var2);
}

