/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile;

import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.BuilderTaskOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.DynamicTopoData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.Sorter;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;

public class ChunkSortOutput
extends BuilderTaskOutput {
    private Sorter sorter;
    private boolean reuseUploadedIndexData;

    public ChunkSortOutput(RenderSection render, int buildTime) {
        super(render, buildTime);
    }

    public ChunkSortOutput(RenderSection render, int buildTime, Sorter data) {
        this(render, buildTime);
        this.setSorter(data);
    }

    public void setSorter(Sorter sorter) {
        this.sorter = sorter;
        this.reuseUploadedIndexData = false;
    }

    public Sorter getSorter() {
        return this.sorter;
    }

    public void markAsReusingUploadedData() {
        this.reuseUploadedIndexData = true;
    }

    public boolean isReusingUploadedIndexData() {
        return this.reuseUploadedIndexData;
    }

    public DynamicTopoData.DynamicTopoSorter getDynamicSorter() {
        DynamicTopoData.DynamicTopoSorter dynamicSorter;
        Sorter sorter = this.sorter;
        return sorter instanceof DynamicTopoData.DynamicTopoSorter ? (dynamicSorter = (DynamicTopoData.DynamicTopoSorter)sorter) : null;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.sorter != null) {
            this.sorter.destroy();
        }
    }

    @Override
    protected long calculateResultSize() {
        if (this.sorter == null) {
            return 0L;
        }
        NativeBuffer indexBuffer = this.sorter.getIndexBuffer();
        if (indexBuffer == null) {
            return 0L;
        }
        return indexBuffer.getLength();
    }
}

