/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.mesh;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.ShadeMode;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_10444;
import net.minecraft.class_11515;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_3532;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public final class EncodingFormat {
    static final int HEADER_BITS = 0;
    static final int HEADER_FACE_NORMAL = 1;
    static final int HEADER_TINT_INDEX = 2;
    static final int HEADER_TAG = 3;
    public static final int HEADER_STRIDE = 4;
    static final int VERTEX_X;
    static final int VERTEX_Y;
    static final int VERTEX_Z;
    static final int VERTEX_COLOR;
    static final int VERTEX_U;
    static final int VERTEX_V;
    static final int VERTEX_LIGHTMAP;
    static final int VERTEX_NORMAL;
    public static final int VERTEX_STRIDE;
    public static final int QUAD_STRIDE;
    public static final int QUAD_STRIDE_BYTES;
    public static final int TOTAL_STRIDE;
    static final int[] EMPTY;
    private static final int DIRECTION_COUNT;
    private static final int NULLABLE_DIRECTION_COUNT;
    @Nullable
    private static final class_11515[] NULLABLE_BLOCK_RENDER_LAYERS;
    private static final int NULLABLE_BLOCK_RENDER_LAYER_COUNT;
    private static final TriState[] TRI_STATES;
    private static final int TRI_STATE_COUNT;
    @Nullable
    private static final class_10444.class_10445[] NULLABLE_GLINTS;
    private static final int NULLABLE_GLINT_COUNT;
    private static final ShadeMode[] SHADE_MODES;
    private static final int SHADE_MODE_COUNT;
    private static final int NULL_RENDER_LAYER_INDEX;
    private static final int NULL_GLINT_INDEX;
    private static final int CULL_BIT_LENGTH;
    private static final int LIGHT_BIT_LENGTH;
    private static final int NORMALS_BIT_LENGTH = 4;
    private static final int NORMAL_FACE_BIT_LENGTH = 3;
    private static final int GEOMETRY_BIT_LENGTH = 3;
    private static final int RENDER_LAYER_BIT_LENGTH;
    private static final int EMISSIVE_BIT_LENGTH = 1;
    private static final int DIFFUSE_BIT_LENGTH = 1;
    private static final int AO_BIT_LENGTH;
    private static final int GLINT_BIT_LENGTH;
    private static final int SHADE_MODE_BIT_LENGTH;
    private static final int CULL_BIT_OFFSET = 0;
    private static final int LIGHT_BIT_OFFSET;
    private static final int NORMAL_FACE_BIT_OFFSET;
    private static final int NORMALS_BIT_OFFSET;
    private static final int GEOMETRY_BIT_OFFSET;
    private static final int RENDER_LAYER_BIT_OFFSET;
    private static final int EMISSIVE_BIT_OFFSET;
    private static final int DIFFUSE_BIT_OFFSET;
    private static final int AO_BIT_OFFSET;
    private static final int GLINT_BIT_OFFSET;
    private static final int SHADE_MODE_BIT_OFFSET;
    private static final int TOTAL_BIT_LENGTH;
    private static final int CULL_MASK;
    private static final int LIGHT_MASK;
    private static final int NORMAL_FACE_MASK;
    private static final int NORMALS_MASK;
    private static final int GEOMETRY_MASK;
    private static final int RENDER_LAYER_MASK;
    private static final int EMISSIVE_MASK;
    private static final int DIFFUSE_MASK;
    private static final int AO_MASK;
    private static final int GLINT_MASK;
    private static final int SHADE_MODE_MASK;

    private EncodingFormat() {
    }

    private static int bitMask(int bitLength, int bitOffset) {
        return (1 << bitLength) - 1 << bitOffset;
    }

    @Nullable
    static class_2350 cullFace(int bits) {
        return ModelHelper.faceFromIndex((int)((bits & CULL_MASK) >>> 0));
    }

    static int cullFace(int bits, @Nullable class_2350 face) {
        return bits & ~CULL_MASK | ModelHelper.toFaceIndex((class_2350)face) << 0;
    }

    static class_2350 lightFace(int bits) {
        return ModelHelper.faceFromIndex((int)((bits & LIGHT_MASK) >>> LIGHT_BIT_OFFSET));
    }

    static int lightFace(int bits, class_2350 face) {
        return bits & ~LIGHT_MASK | ModelHelper.toFaceIndex((class_2350)face) << LIGHT_BIT_OFFSET;
    }

    static int normalFlags(int bits) {
        return (bits & NORMALS_MASK) >>> NORMALS_BIT_OFFSET;
    }

    static int normalFlags(int bits, int normalFlags) {
        return bits & ~NORMALS_MASK | normalFlags << NORMALS_BIT_OFFSET & NORMALS_MASK;
    }

    static int geometryFlags(int bits) {
        return (bits & GEOMETRY_MASK) >>> GEOMETRY_BIT_OFFSET;
    }

    static int geometryFlags(int bits, int geometryFlags) {
        return bits & ~GEOMETRY_MASK | geometryFlags << GEOMETRY_BIT_OFFSET & GEOMETRY_MASK;
    }

    static ModelQuadFacing normalFace(int bits) {
        return ModelQuadFacing.VALUES[(bits & NORMAL_FACE_MASK) >>> NORMAL_FACE_BIT_OFFSET];
    }

    static int normalFace(int bits, ModelQuadFacing face) {
        return bits & ~NORMAL_FACE_MASK | face.ordinal() << NORMAL_FACE_BIT_OFFSET & NORMAL_FACE_MASK;
    }

    @Nullable
    static class_11515 renderLayer(int bits) {
        return NULLABLE_BLOCK_RENDER_LAYERS[(bits & RENDER_LAYER_MASK) >>> RENDER_LAYER_BIT_OFFSET];
    }

    static int renderLayer(int bits, @Nullable class_11515 renderLayer) {
        int index = renderLayer == null ? NULL_RENDER_LAYER_INDEX : renderLayer.ordinal();
        return bits & ~RENDER_LAYER_MASK | index << RENDER_LAYER_BIT_OFFSET;
    }

    static boolean emissive(int bits) {
        return (bits & EMISSIVE_MASK) != 0;
    }

    static int emissive(int bits, boolean emissive) {
        return emissive ? bits | EMISSIVE_MASK : bits & ~EMISSIVE_MASK;
    }

    static boolean diffuseShade(int bits) {
        return (bits & DIFFUSE_MASK) != 0;
    }

    static int diffuseShade(int bits, boolean shade) {
        return shade ? bits | DIFFUSE_MASK : bits & ~DIFFUSE_MASK;
    }

    static TriState ambientOcclusion(int bits) {
        return TRI_STATES[(bits & AO_MASK) >>> AO_BIT_OFFSET];
    }

    static int ambientOcclusion(int bits, TriState ao) {
        return bits & ~AO_MASK | ao.ordinal() << AO_BIT_OFFSET;
    }

    @Nullable
    static class_10444.class_10445 glint(int bits) {
        return NULLABLE_GLINTS[(bits & GLINT_MASK) >>> GLINT_BIT_OFFSET];
    }

    static int glint(int bits, @Nullable class_10444.class_10445 glint) {
        int index = glint == null ? NULL_GLINT_INDEX : glint.ordinal();
        return bits & ~GLINT_MASK | index << GLINT_BIT_OFFSET;
    }

    static ShadeMode shadeMode(int bits) {
        return SHADE_MODES[(bits & SHADE_MODE_MASK) >>> SHADE_MODE_BIT_OFFSET];
    }

    static int shadeMode(int bits, ShadeMode mode) {
        return bits & ~SHADE_MODE_MASK | mode.ordinal() << SHADE_MODE_BIT_OFFSET;
    }

    static {
        VertexFormat format = class_290.field_1590;
        VERTEX_X = 4;
        VERTEX_Y = 5;
        VERTEX_Z = 6;
        VERTEX_COLOR = 7;
        VERTEX_U = 8;
        VERTEX_V = VERTEX_U + 1;
        VERTEX_LIGHTMAP = 10;
        VERTEX_NORMAL = 11;
        VERTEX_STRIDE = format.getVertexSize() / 4;
        QUAD_STRIDE = VERTEX_STRIDE * 4;
        QUAD_STRIDE_BYTES = QUAD_STRIDE * 4;
        TOTAL_STRIDE = 4 + QUAD_STRIDE;
        Preconditions.checkState((VERTEX_STRIDE == QuadView.VANILLA_VERTEX_STRIDE ? 1 : 0) != 0, (String)"Indigo vertex stride (%s) mismatched with rendering API (%s)", (int)VERTEX_STRIDE, (int)QuadView.VANILLA_VERTEX_STRIDE);
        Preconditions.checkState((QUAD_STRIDE == QuadView.VANILLA_QUAD_STRIDE ? 1 : 0) != 0, (String)"Indigo quad stride (%s) mismatched with rendering API (%s)", (int)QUAD_STRIDE, (int)QuadView.VANILLA_QUAD_STRIDE);
        EMPTY = new int[TOTAL_STRIDE];
        DIRECTION_COUNT = class_2350.values().length;
        NULLABLE_DIRECTION_COUNT = DIRECTION_COUNT + 1;
        NULLABLE_BLOCK_RENDER_LAYERS = (class_11515[])ArrayUtils.add((Object[])class_11515.values(), null);
        NULLABLE_BLOCK_RENDER_LAYER_COUNT = NULLABLE_BLOCK_RENDER_LAYERS.length;
        TRI_STATES = TriState.values();
        TRI_STATE_COUNT = TRI_STATES.length;
        NULLABLE_GLINTS = (class_10444.class_10445[])ArrayUtils.add((Object[])class_10444.class_10445.values(), null);
        NULLABLE_GLINT_COUNT = NULLABLE_GLINTS.length;
        SHADE_MODES = ShadeMode.values();
        SHADE_MODE_COUNT = SHADE_MODES.length;
        NULL_RENDER_LAYER_INDEX = NULLABLE_BLOCK_RENDER_LAYER_COUNT - 1;
        NULL_GLINT_INDEX = NULLABLE_GLINT_COUNT - 1;
        CULL_BIT_LENGTH = class_3532.method_15342((int)NULLABLE_DIRECTION_COUNT);
        LIGHT_BIT_LENGTH = class_3532.method_15342((int)DIRECTION_COUNT);
        RENDER_LAYER_BIT_LENGTH = class_3532.method_15342((int)NULLABLE_BLOCK_RENDER_LAYER_COUNT);
        AO_BIT_LENGTH = class_3532.method_15342((int)TRI_STATE_COUNT);
        GLINT_BIT_LENGTH = class_3532.method_15342((int)NULLABLE_GLINT_COUNT);
        SHADE_MODE_BIT_LENGTH = class_3532.method_15342((int)SHADE_MODE_COUNT);
        LIGHT_BIT_OFFSET = 0 + CULL_BIT_LENGTH;
        NORMAL_FACE_BIT_OFFSET = LIGHT_BIT_OFFSET + LIGHT_BIT_LENGTH;
        NORMALS_BIT_OFFSET = NORMAL_FACE_BIT_OFFSET + 3;
        GEOMETRY_BIT_OFFSET = NORMALS_BIT_OFFSET + 4;
        RENDER_LAYER_BIT_OFFSET = GEOMETRY_BIT_OFFSET + 3;
        EMISSIVE_BIT_OFFSET = RENDER_LAYER_BIT_OFFSET + RENDER_LAYER_BIT_LENGTH;
        DIFFUSE_BIT_OFFSET = EMISSIVE_BIT_OFFSET + 1;
        AO_BIT_OFFSET = DIFFUSE_BIT_OFFSET + 1;
        GLINT_BIT_OFFSET = AO_BIT_OFFSET + AO_BIT_LENGTH;
        SHADE_MODE_BIT_OFFSET = GLINT_BIT_OFFSET + GLINT_BIT_LENGTH;
        TOTAL_BIT_LENGTH = SHADE_MODE_BIT_OFFSET + SHADE_MODE_BIT_LENGTH;
        CULL_MASK = EncodingFormat.bitMask(CULL_BIT_LENGTH, 0);
        LIGHT_MASK = EncodingFormat.bitMask(LIGHT_BIT_LENGTH, LIGHT_BIT_OFFSET);
        NORMAL_FACE_MASK = EncodingFormat.bitMask(3, NORMAL_FACE_BIT_OFFSET);
        NORMALS_MASK = EncodingFormat.bitMask(4, NORMALS_BIT_OFFSET);
        GEOMETRY_MASK = EncodingFormat.bitMask(3, GEOMETRY_BIT_OFFSET);
        RENDER_LAYER_MASK = EncodingFormat.bitMask(RENDER_LAYER_BIT_LENGTH, RENDER_LAYER_BIT_OFFSET);
        EMISSIVE_MASK = EncodingFormat.bitMask(1, EMISSIVE_BIT_OFFSET);
        DIFFUSE_MASK = EncodingFormat.bitMask(1, DIFFUSE_BIT_OFFSET);
        AO_MASK = EncodingFormat.bitMask(AO_BIT_LENGTH, AO_BIT_OFFSET);
        GLINT_MASK = EncodingFormat.bitMask(GLINT_BIT_LENGTH, GLINT_BIT_OFFSET);
        SHADE_MODE_MASK = EncodingFormat.bitMask(SHADE_MODE_BIT_LENGTH, SHADE_MODE_BIT_OFFSET);
        Preconditions.checkArgument((TOTAL_BIT_LENGTH <= 32 ? 1 : 0) != 0, (String)"Indigo header encoding bit count (%s) exceeds integer bit length)", (int)TOTAL_STRIDE);
    }
}

