/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.worldgen.feature.configurations.BasicTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class BasicTreeFeature
extends BOPTreeFeature<BasicTreeConfiguration> {
    public BasicTreeFeature(Codec<BasicTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean method_12775(class_5281 world, class_5819 random, class_2338 pos, BiConsumer<class_2338, class_2680> roots, BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, class_4643 configBase) {
        BasicTreeConfiguration config = (BasicTreeConfiguration)configBase;
        int height = random.method_43048(config.maxHeight - config.minHeight) + config.minHeight;
        boolean hasSpace = true;
        if (pos.method_10264() >= world.method_31607() + 1 && pos.method_10264() + height + 1 <= world.method_31600()) {
            int x;
            int leavesRadius;
            int currentLayer;
            int y;
            for (int y2 = pos.method_10264(); y2 <= pos.method_10264() + 1 + height; ++y2) {
                int radius = 1;
                if (y2 == pos.method_10264()) {
                    radius = 0;
                }
                if (y2 >= pos.method_10264() + 1 + height - 2) {
                    radius = 2;
                }
                for (int x2 = pos.method_10263() - radius; x2 <= pos.method_10263() + radius && hasSpace; ++x2) {
                    for (int z = pos.method_10260() - radius; z <= pos.method_10260() + radius && hasSpace; ++z) {
                        if (y2 >= world.method_31607() && y2 < world.method_31600()) {
                            if (this.canReplace((class_1936)world, new class_2338(x2, y2, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            class_2338 soilPos = pos.method_10074();
            class_2248 soil = world.method_8320(soilPos).method_26204();
            if (world.method_8320(pos.method_10074()).method_26204() == class_2246.field_10219 || world.method_8320(pos.method_10074()).method_26204() == class_2246.field_10402) {
                world.method_8652(soilPos, class_2246.field_10566.method_9564(), 3);
            }
            int leavesLayers = config.leafLayers - 1;
            for (y = pos.method_10264() + height - leavesLayers; y <= pos.method_10264() + height; ++y) {
                currentLayer = y - (pos.method_10264() + height);
                leavesRadius = config.maxLeavesRadius - currentLayer / config.leavesLayerHeight;
                for (x = pos.method_10263() - leavesRadius; x <= pos.method_10263() + leavesRadius; ++x) {
                    int xDiff = x - pos.method_10263();
                    for (int z = pos.method_10260() - leavesRadius; z <= pos.method_10260() + leavesRadius; ++z) {
                        int zDiff = z - pos.method_10260();
                        if (Math.abs(xDiff) == leavesRadius && Math.abs(zDiff) == leavesRadius && (random.method_43048(2) == 0 || currentLayer == 0)) continue;
                        class_2338 leavesPos = new class_2338(x, y, z);
                        if (this.canReplace((class_1936)world, leavesPos)) {
                            if (config.altFoliageProvider.method_23455(random, pos) != class_2246.field_10124.method_9564()) {
                                if (random.method_43048(4) == 0) {
                                    this.placeAltLeaves((class_1936)world, leavesPos, leaves, config);
                                } else {
                                    this.placeLeaves((class_1936)world, leavesPos, leaves, config);
                                }
                            } else {
                                this.placeLeaves((class_1936)world, leavesPos, leaves, config);
                            }
                        }
                        int hanging_height = random.method_43048(2) + 1;
                        if (config.hangingProvider.method_23455(random, pos) == class_2246.field_10124.method_9564() || random.method_43048(2) != 0) continue;
                        for (int i = 0; i < hanging_height; ++i) {
                            if (!this.canReplace((class_1936)world, leavesPos.method_10087(i))) continue;
                            this.setHanging((class_1936)world, leavesPos.method_10087(i), config);
                        }
                    }
                }
            }
            this.generateTrunk((class_1936)world, pos, height, logs, config);
            if (config.vineProvider.method_23455(random, pos) != class_2246.field_10124.method_9564()) {
                for (y = pos.method_10264() - leavesLayers + height; y <= pos.method_10264() + height; ++y) {
                    currentLayer = y - (pos.method_10264() + height);
                    leavesRadius = config.maxLeavesRadius + config.leavesOffset - currentLayer / config.leavesLayerHeight;
                    for (x = pos.method_10263() - leavesRadius; x <= pos.method_10263() + leavesRadius; ++x) {
                        for (int z = pos.method_10260() - leavesRadius; z <= pos.method_10260() + leavesRadius; ++z) {
                            class_2338 blockpos3 = new class_2338(x, y, z);
                            if (!world.method_8320(blockpos3).method_26164(class_3481.field_15503)) continue;
                            class_2338 westPos = blockpos3.method_10067();
                            class_2338 eastPos = blockpos3.method_10078();
                            class_2338 northPos = blockpos3.method_10095();
                            class_2338 southPos = blockpos3.method_10072();
                            if (random.method_43048(4) == 0 && this.canPlaceVinesOn((class_1936)world, westPos)) {
                                this.extendVines((class_1936)world, random, westPos, class_2350.field_11034, config);
                            }
                            if (random.method_43048(4) == 0 && this.canPlaceVinesOn((class_1936)world, eastPos)) {
                                this.extendVines((class_1936)world, random, eastPos, class_2350.field_11039, config);
                            }
                            if (random.method_43048(4) == 0 && this.canPlaceVinesOn((class_1936)world, northPos)) {
                                this.extendVines((class_1936)world, random, northPos, class_2350.field_11035, config);
                            }
                            if (random.method_43048(4) != 0 || !this.canPlaceVinesOn((class_1936)world, southPos)) continue;
                            this.extendVines((class_1936)world, random, southPos, class_2350.field_11043, config);
                        }
                    }
                }
            }
            if (config.trunkFruitProvider.method_23455(random, pos) != class_2246.field_10124.method_9564() && random.method_43048(5) == 0 && height > 5) {
                for (int l3 = 0; l3 < 2; ++l3) {
                    for (class_2350 Direction : class_2350.class_2353.field_11062) {
                        if (random.method_43048(4 - l3) != 0) continue;
                        class_2350 Direction1 = Direction.method_10153();
                        this.generateTrunkFruit((class_1936)world, random, random.method_43048(3), pos.method_10069(Direction1.method_10148(), height - 5 + l3, Direction1.method_10165()), Direction, config);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected void generateTrunk(class_1936 world, class_2338 start, int height, BiConsumer<class_2338, class_2680> logs, BasicTreeConfiguration config) {
        for (int layer = 0; layer < height; ++layer) {
            class_2338 blockpos2 = start.method_10086(layer);
            if (!this.canReplace(world, blockpos2)) continue;
            this.placeLog(world, start.method_10086(layer), logs, config);
        }
    }

    private void generateTrunkFruit(class_1936 world, class_5819 random, int age, class_2338 pos, class_2350 direction, BasicTreeConfiguration config) {
        if (config.trunkFruitProvider.method_23455(random, pos) == class_2246.field_10302.method_9564()) {
            this.method_13153((class_1945)world, pos, (class_2680)((class_2680)config.trunkFruitProvider.method_23455(random, pos).method_11657((class_2769)class_2282.field_10779, (Comparable)Integer.valueOf(age))).method_11657((class_2769)class_2282.field_11177, (Comparable)direction));
        } else {
            this.method_13153((class_1945)world, pos, (class_2680)config.trunkFruitProvider.method_23455(random, pos).method_11657((class_2769)class_2282.field_11177, (Comparable)direction));
        }
    }

    private class_2680 getVineStateForSide(class_5819 random, class_2338 pos, class_2350 side, BasicTreeConfiguration config) {
        return config.vineProvider.method_23455(random, pos).method_26204() instanceof class_2541 ? (class_2680)config.vineProvider.method_23455(random, pos).method_11657((class_2769)class_2541.method_10828((class_2350)side), (Comparable)Boolean.valueOf(true)) : config.vineProvider.method_23455(random, pos);
    }

    private void extendVines(class_1936 world, class_5819 random, class_2338 pos, class_2350 side, BasicTreeConfiguration config) {
        class_2680 vineState = this.getVineStateForSide(random, pos, side, config);
        this.method_13153((class_1945)world, pos, vineState);
        pos = pos.method_10074();
        for (int length = 4; this.canPlaceVinesOn(world, pos) && length > 0; --length) {
            this.method_13153((class_1945)world, pos, vineState);
            pos = pos.method_10074();
        }
    }

    protected boolean canPlaceVinesOn(class_1936 world, class_2338 pos) {
        return world.method_8320(pos).method_26215();
    }
}

