/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueProvider;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_6880;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;

public class ButtonWidget
extends Button {
    private static final class_8666 SPRITES = new class_8666(class_2960.method_60656((String)"widget/button"), class_2960.method_60656((String)"widget/button_disabled"), class_2960.method_60656((String)"widget/button_highlighted"));
    private static final class_8666 DARK_SPRITES = new class_8666(class_2960.method_60654((String)"roughlyenoughitems:widget/button_dark"), class_2960.method_60654((String)"roughlyenoughitems:widget/button_disabled_dark"), class_2960.method_60654((String)"roughlyenoughitems:widget/button_highlighted_dark"));
    private Rectangle bounds;
    private boolean enabled = true;
    private class_2561 text;
    @Nullable
    private Integer tint;
    @Nullable
    private Consumer<Button> onClick;
    @Nullable
    private BiConsumer<class_332, Button> onRender;
    private boolean focusable = false;
    private boolean focused = false;
    @Nullable
    private @Nullable Function<Button, @Nullable class_2561[]> tooltipFunction;
    @Nullable
    private BiFunction<Button, Point, Integer> textColorFunction;
    private final ValueAnimator<Color> darkBackground;
    private ValueProvider<Double> alpha;

    public ButtonWidget(Rectangle rectangle, class_2561 text) {
        this.bounds = Objects.requireNonNull(rectangle);
        this.text = Objects.requireNonNull(text);
        this.darkBackground = ValueAnimator.ofColor().withConvention(() -> Color.ofTransparent((int)(REIRuntime.getInstance().isDarkThemeEnabled() ? -1 : 0xFFFFFF)), ValueAnimator.typicalTransitionTime());
        this.alpha = ValueProvider.constant((Object)1.0);
    }

    @Override
    public final boolean method_25370() {
        return this.focused;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public final OptionalInt getTint() {
        return OptionalInt.empty();
    }

    @Override
    public final void setTint(int tint) {
        this.tint = tint;
    }

    @Override
    public final void removeTint() {
        this.tint = null;
    }

    @Override
    public final class_2561 getText() {
        return this.text;
    }

    @Override
    public final void setText(class_2561 text) {
        this.text = text;
    }

    @Override
    @Nullable
    public final Consumer<Button> getOnClick() {
        return this.onClick;
    }

    @Override
    public final void setOnClick(@Nullable Consumer<Button> onClick) {
        this.onClick = onClick;
    }

    @Override
    @Nullable
    public final BiConsumer<class_332, Button> getOnRender() {
        return this.onRender;
    }

    @Override
    public final void setOnRender(BiConsumer<class_332, Button> onRender) {
        this.onRender = onRender;
    }

    @Override
    public final boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public final void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    public void setAlpha(ValueProvider<Double> alpha) {
        this.alpha = alpha;
    }

    @Override
    @Nullable
    public final class_2561[] getTooltip() {
        if (this.tooltipFunction == null) {
            return null;
        }
        return this.tooltipFunction.apply(this);
    }

    @Override
    public final void setTooltip(@Nullable @Nullable Function<Button, @Nullable class_2561[]> tooltip) {
        this.tooltipFunction = tooltip;
    }

    @Override
    public final void setTextColor(@Nullable BiFunction<Button, Point, Integer> textColorFunction) {
        this.textColorFunction = textColorFunction;
    }

    @Override
    public final int getTextColor(Point mouse) {
        Integer apply;
        if (this.textColorFunction != null && (apply = this.textColorFunction.apply(this, mouse)) != null) {
            return apply;
        }
        if (!this.enabled) {
            return 0xA0A0A0;
        }
        if (this.isFocused(mouse.x, mouse.y)) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    @Override
    public final Rectangle getBounds() {
        return this.bounds;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        class_2561[] tooltip;
        this.darkBackground.update((double)delta);
        this.alpha.update((double)delta);
        if (this.onRender != null) {
            this.onRender.accept(graphics, this);
        }
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        int alphaAsInt = (int)((Double)this.alpha.value() * 255.0);
        this.renderBackground(graphics, x, y, width, height, this.isFocused(mouseX, mouseY), false, Color.ofTransparent((int)(0xFFFFFF | alphaAsInt << 24)));
        Color darkBackgroundColor = (Color)this.darkBackground.value();
        darkBackgroundColor = Color.ofRGBA((int)darkBackgroundColor.getRed(), (int)darkBackgroundColor.getGreen(), (int)darkBackgroundColor.getBlue(), (int)((int)Math.round((double)darkBackgroundColor.getAlpha() * (Double)this.alpha.value())));
        this.renderBackground(graphics, x, y, width, height, this.isFocused(mouseX, mouseY), true, darkBackgroundColor);
        int color = 0xE0E0E0;
        if (!this.enabled) {
            color = 0xA0A0A0;
        } else if (this.isFocused(mouseX, mouseY)) {
            color = 0xFFFFA0;
        }
        if (this.tint != null) {
            graphics.method_25296(x + 1, y + 1, x + width - 1, y + height - 1, this.tint.intValue(), this.tint.intValue());
        }
        if (alphaAsInt > 10) {
            graphics.method_27534(this.font, this.getText(), x + width / 2, y + (height - 8) / 2, color | alphaAsInt << 24);
        }
        if ((tooltip = this.getTooltip()) != null) {
            if (!this.focused && this.containsMouse(mouseX, mouseY)) {
                Tooltip.create(tooltip).queue();
            } else if (this.focused) {
                Tooltip.create(new Point(x + width / 2, y + height / 2), tooltip).queue();
            }
        }
    }

    protected boolean isFocused(int mouseX, int mouseY) {
        return this.containsMouse(mouseX, mouseY) || this.focused;
    }

    @Nullable
    public class_8016 method_48205(class_8023 event) {
        return this.enabled && this.focusable ? class_8016.method_48193((class_364)this) : null;
    }

    @Override
    public void onClick() {
        Consumer<Button> onClick = this.getOnClick();
        if (onClick != null) {
            onClick.accept(this);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX, mouseY) && this.isEnabled() && button == 0) {
            this.minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            this.onClick();
            return true;
        }
        return false;
    }

    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (this.isEnabled() && this.focused) {
            if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
                return false;
            }
            this.minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            this.onClick();
            return true;
        }
        return false;
    }

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    protected void renderBackground(class_332 graphics, int x, int y, int width, int height, boolean focused) {
        this.renderBackground(graphics, x, y, width, height, focused, REIRuntime.getInstance().isDarkThemeEnabled(), Color.ofTransparent((int)-1));
    }

    protected void renderBackground(class_332 graphics, int x, int y, int width, int height, boolean focused, boolean dark, Color color) {
        class_8666 sprites = dark ? DARK_SPRITES : SPRITES;
        class_2960 texture = sprites.method_52729(this.isEnabled(), focused);
        graphics.method_52707(class_10799.field_56883, texture, x, y, width, height, color.getColor());
    }
}

