/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire.WildfireBarrageAttackTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire.WildfireShockwaveAttackTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire.WildfireSummonBlazeTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4120;
import net.minecraft.class_4121;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4802;
import net.minecraft.class_4818;
import net.minecraft.class_4824;
import net.minecraft.class_5753;
import net.minecraft.class_6019;

public final class WildfireBrain {
    public static final List<class_4140<?>> MEMORY_MODULES;
    public static final List<class_4149<? extends class_4148<? super WildfireEntity>>> SENSORS;
    private static final class_6019 BARRAGE_ATTACK_COOLDOWN_PROVIDER;
    private static final class_6019 SHOCKWAVE_ATTACK_COOLDOWN_PROVIDER;
    private static final class_6019 SUMMON_BLAZE_COOLDOWN_PROVIDER;
    private static final class_6019 AVOID_MEMORY_DURATION;

    public static class_4095<?> create(Dynamic<?> dynamic) {
        class_4095.class_5303 profile = class_4095.method_28311(MEMORY_MODULES, SENSORS);
        class_4095 brain = profile.method_28335(dynamic);
        WildfireBrain.addCoreActivities((class_4095<WildfireEntity>)brain);
        WildfireBrain.addIdleActivities((class_4095<WildfireEntity>)brain);
        WildfireBrain.addFightActivities((class_4095<WildfireEntity>)brain);
        WildfireBrain.addAvoidActivities((class_4095<WildfireEntity>)brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void addCoreActivities(class_4095<WildfireEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4110(45, 90), (Object)new class_4112(), (Object)new class_5753((class_4140)FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get()), (Object)new class_5753((class_4140)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get()), (Object)new class_5753((class_4140)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get())));
    }

    private static void addIdleActivities(class_4095<WildfireEntity> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_4824.method_47120((serverLevel, wildfire) -> true, WildfireBrain::getTarget)), (Object)Pair.of((Object)1, WildfireBrain.makeRandomWanderTask())));
    }

    private static void addFightActivities(class_4095<WildfireEntity> brain) {
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of((Object)((Object)new WildfireSummonBlazeTask()), (Object)((Object)new WildfireBarrageAttackTask()), (Object)((Object)new WildfireShockwaveAttackTask())), class_4140.field_22355);
    }

    private static void addAvoidActivities(class_4095<WildfireEntity> brain) {
        brain.method_24527(class_4168.field_22399, 10, ImmutableList.of((Object)class_4121.method_24603((class_4140)class_4140.field_22357, (float)1.4f, (int)16, (boolean)true), WildfireBrain.makeRandomWanderTask()), class_4140.field_22357);
    }

    private static class_4118<WildfireEntity> makeRandomWanderTask() {
        return new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)0.6f), (Object)2), (Object)Pair.of((Object)class_4120.method_47104((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)));
    }

    public static void updateActivities(WildfireEntity wildfire) {
        wildfire.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_22396, (Object)class_4168.field_22399, (Object)class_4168.field_18595));
    }

    public static void setBarrageAttackCooldown(WildfireEntity wildfire) {
        wildfire.method_18868().method_18878((class_4140)FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get(), (Object)BARRAGE_ATTACK_COOLDOWN_PROVIDER.method_35008(wildfire.method_59922()));
        WildfireBrain.onCooldown(wildfire);
    }

    public static void setShockwaveAttackCooldown(WildfireEntity wildfire) {
        wildfire.method_18868().method_18878((class_4140)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get(), (Object)SHOCKWAVE_ATTACK_COOLDOWN_PROVIDER.method_35008(wildfire.method_59922()));
        WildfireBrain.onCooldown(wildfire);
    }

    public static void setSummonBlazeCooldown(WildfireEntity wildfire) {
        wildfire.method_18868().method_18878((class_4140)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get(), (Object)SUMMON_BLAZE_COOLDOWN_PROVIDER.method_35008(wildfire.method_59922()));
        WildfireBrain.onCooldown(wildfire);
    }

    public static boolean shouldRunAway(WildfireEntity wildfire) {
        return wildfire.method_18868().method_18904((class_4140)FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get()).isPresent() && wildfire.method_18868().method_18904((class_4140)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get()).isPresent() && (wildfire.method_18868().method_18904((class_4140)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get()).isPresent() || wildfire.getSummonedBlazesCount() == 2);
    }

    public static void onCooldown(WildfireEntity wildfire) {
        if (!WildfireBrain.shouldRunAway(wildfire)) {
            return;
        }
        class_1309 attackTarget = wildfire.method_18868().method_18904(class_4140.field_22355).orElse(null);
        if (attackTarget == null) {
            return;
        }
        WildfireBrain.runAwayFrom(wildfire, attackTarget);
    }

    public static void onAttacked(WildfireEntity wildfire, class_1309 attacker) {
        WildfireBrain.setAttackTarget(wildfire, attacker);
        if (WildfireBrain.shouldRunAway(wildfire)) {
            WildfireBrain.runAwayFrom(wildfire, attacker);
        }
    }

    private static Optional<? extends class_1309> getTarget(class_3218 level, WildfireEntity wildfire) {
        class_1657 nearestVisibleTargetablePlayer = wildfire.method_18868().method_18904(class_4140.field_22354).orElse(wildfire.method_37908().method_18460((class_1297)wildfire, 32.0));
        if (nearestVisibleTargetablePlayer == null) {
            return Optional.empty();
        }
        return Optional.of(nearestVisibleTargetablePlayer);
    }

    public static void setAttackTarget(WildfireEntity wildfire, class_1309 target) {
        wildfire.method_18868().method_18875(class_4140.field_19293);
        wildfire.method_18868().method_24525(class_4140.field_22355, (Object)target, 200L);
    }

    private static void runAwayFrom(WildfireEntity wildfire, class_1309 target) {
        wildfire.method_18868().method_18875(class_4140.field_22355);
        wildfire.method_18868().method_18875(class_4140.field_18445);
        wildfire.method_18868().method_24525(class_4140.field_22357, (Object)target, (long)AVOID_MEMORY_DURATION.method_35008(wildfire.method_37908().method_8409()));
    }

    static {
        SENSORS = List.of(class_4149.field_18467, class_4149.field_18469);
        MEMORY_MODULES = List.of(class_4140.field_18449, class_4140.field_18441, class_4140.field_18442, class_4140.field_22354, class_4140.field_22355, class_4140.field_18446, class_4140.field_18445, class_4140.field_22357, class_4140.field_19293, (class_4140)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SUMMON_BLAZE_COOLDOWN.get(), (class_4140)FriendsAndFoesMemoryModuleTypes.WILDFIRE_BARRAGE_ATTACK_COOLDOWN.get(), (class_4140)FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get());
        SUMMON_BLAZE_COOLDOWN_PROVIDER = class_6019.method_35017((int)600, (int)1200);
        BARRAGE_ATTACK_COOLDOWN_PROVIDER = class_6019.method_35017((int)150, (int)300);
        SHOCKWAVE_ATTACK_COOLDOWN_PROVIDER = class_6019.method_35017((int)150, (int)300);
        AVOID_MEMORY_DURATION = class_4802.method_24505((int)5, (int)20);
    }
}

