/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab;

import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CrabBrain;
import com.faboslav.friendsandfoes.common.entity.animation.CrabAnimations;
import com.faboslav.friendsandfoes.common.entity.pose.FriendsAndFoesEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public final class CrabWaveTask
extends class_4097<CrabEntity> {
    private static final int WAVE_DURATION = CrabAnimations.WAVE.get().lengthInTicks();
    private class_1309 nearestTarget;
    private int waveTicks = 0;
    private int maxWaveTicks = 0;

    public CrabWaveTask() {
        super(Map.of(class_4140.field_18444, class_4141.field_18456, class_4140.field_18448, class_4141.field_18457, class_4140.field_28325, class_4141.field_18457, (class_4140)FriendsAndFoesMemoryModuleTypes.CRAB_WAVE_COOLDOWN.get(), class_4141.field_18457, (class_4140)FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), class_4141.field_18457, (class_4140)FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), class_4141.field_18457), WAVE_DURATION);
    }

    protected boolean checkExtraStartConditions(class_3218 world, CrabEntity crab) {
        if (crab.method_5942().method_23966()) {
            return false;
        }
        class_1309 nearestTarget = crab.method_18868().method_46873(class_4140.field_18444).orElse(null);
        if (nearestTarget == null) {
            return false;
        }
        this.nearestTarget = nearestTarget;
        return true;
    }

    protected void start(class_3218 world, CrabEntity crab, long time) {
        MovementUtil.stopMovement((class_1308)crab);
        class_4215.method_19554((class_1309)crab, (class_1309)this.nearestTarget);
        crab.method_5988().method_35111((class_1297)this.nearestTarget);
        crab.method_5988().method_6231();
        this.waveTicks = 0;
        this.maxWaveTicks = WAVE_DURATION;
        crab.startWaveAnimation();
    }

    protected boolean canStillUse(class_3218 world, CrabEntity crab, long time) {
        return this.waveTicks <= this.maxWaveTicks;
    }

    protected void tick(class_3218 world, CrabEntity crab, long time) {
        ++this.waveTicks;
    }

    protected void stop(class_3218 world, CrabEntity crab, long time) {
        crab.setEntityPose(FriendsAndFoesEntityPose.IDLE);
        CrabBrain.setWaveCooldown(crab);
    }
}

