/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json;

import com.faboslav.friendsandfoes.common.entity.animation.AnimationChannel;
import com.faboslav.friendsandfoes.common.entity.animation.animator.Keyframe;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.AnimationTarget;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationParser;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class AnimationTypeManager {
    private static final ImmutableBiMap<class_2960, AnimationTarget> DEFAULT_TARGETS = ImmutableBiMap.of((Object)class_2960.method_60656((String)"position"), (Object)AnimationTarget.POSITION, (Object)class_2960.method_60656((String)"rotation"), (Object)AnimationTarget.ROTATION, (Object)class_2960.method_60656((String)"scale"), (Object)AnimationTarget.SCALE);
    private static final ImmutableBiMap<class_2960, AnimationChannel.Interpolation> DEFAULT_INTERPOLATIONS = ImmutableBiMap.of((Object)class_2960.method_60656((String)"linear"), (Object)AnimationChannel.Interpolations.LINEAR, (Object)class_2960.method_60656((String)"catmullrom"), (Object)AnimationChannel.Interpolations.CATMULLROM);
    private static ImmutableBiMap<class_2960, AnimationTarget> TARGETS = DEFAULT_TARGETS;
    private static ImmutableMap<AnimationChannel.Target, AnimationTarget> TARGETS_BY_CHANNEL_TARGET = ImmutableMap.of();
    private static ImmutableMap<AnimationTarget, Codec<Keyframe>> KEYFRAME_CODECS = ImmutableMap.of();
    private static ImmutableBiMap<class_2960, AnimationChannel.Interpolation> INTERPOLATIONS = DEFAULT_INTERPOLATIONS;
    private static String TARGET_LIST = "";
    private static String INTERPOLATION_LIST = "";

    private AnimationTypeManager() {
    }

    @Nullable
    public static AnimationTarget getTarget(class_2960 name) {
        return (AnimationTarget)TARGETS.get((Object)name);
    }

    @Nullable
    public static class_2960 getTargetName(AnimationTarget target) {
        return (class_2960)TARGETS.inverse().get((Object)target);
    }

    @Nullable
    public static AnimationTarget getTargetFromChannelTarget(AnimationChannel.Target target) {
        return (AnimationTarget)TARGETS_BY_CHANNEL_TARGET.get((Object)target);
    }

    @Nullable
    public static Codec<Keyframe> getKeyframeCodec(AnimationTarget target) {
        return (Codec)KEYFRAME_CODECS.get((Object)target);
    }

    @Nullable
    public static AnimationChannel.Interpolation getInterpolation(class_2960 name) {
        return (AnimationChannel.Interpolation)INTERPOLATIONS.get((Object)name);
    }

    @Nullable
    public static class_2960 getInterpolationName(AnimationChannel.Interpolation interpolation) {
        return (class_2960)INTERPOLATIONS.inverse().get((Object)interpolation);
    }

    public static String getTargetList() {
        return TARGET_LIST;
    }

    public static String getInterpolationList() {
        return INTERPOLATION_LIST;
    }

    @ApiStatus.Internal
    public static void init() {
        ImmutableBiMap.Builder targets = ImmutableBiMap.builder().putAll(DEFAULT_TARGETS);
        ImmutableBiMap.Builder interpolations = ImmutableBiMap.builder().putAll(DEFAULT_INTERPOLATIONS);
        TARGETS = targets.buildOrThrow();
        INTERPOLATIONS = interpolations.buildOrThrow();
        AnimationTypeManager.recomputeDerivedFields();
    }

    private static void recomputeDerivedFields() {
        TARGETS_BY_CHANNEL_TARGET = (ImmutableMap)TARGETS.values().stream().collect(ImmutableMap.toImmutableMap(AnimationTarget::channelTarget, Function.identity()));
        KEYFRAME_CODECS = (ImmutableMap)TARGETS.values().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), AnimationParser::keyframeCodec));
        TARGET_LIST = TARGETS.keySet().stream().map(class_2960::toString).collect(Collectors.joining(", "));
        INTERPOLATION_LIST = INTERPOLATIONS.keySet().stream().map(class_2960::toString).collect(Collectors.joining(", "));
    }

    static {
        AnimationTypeManager.recomputeDerivedFields();
    }
}

