/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.parsers.format;

import eu.pb4.placeholders.api.parsers.TagLikeParser;
import org.jetbrains.annotations.Nullable;

public interface BaseFormat
extends TagLikeParser.Format {
    public static final char[] DEFAULT_ARGUMENT_WRAPPER = new char[]{'\"', '\'', '`'};
    public static final char[] LEGACY_ARGUMENT_WRAPPER = new char[]{'\''};

    public int matchStart(String var1, int var2);

    public int matchEnd(String var1, int var2);

    public int matchArgument(String var1, int var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    default public TagLikeParser.Format.Tag findAt(String string, int start, TagLikeParser.Provider provider, TagLikeParser.Context context) {
        if (string.charAt(start) == '\\') {
            return null;
        }
        int mStart = this.matchStart(string, start);
        if (mStart == 0) {
            return null;
        }
        String id = null;
        String argument = "";
        char wrapper = '\u0000';
        StringBuilder builder = new StringBuilder();
        int maxLengthEnd = string.length();
        block0: for (int b = start + mStart; b < maxLengthEnd; ++b) {
            char curr = string.charAt(b);
            boolean matched = true;
            int arg = 0;
            if (wrapper != '\u0000') {
                if (curr == wrapper) {
                    wrapper = '\u0000';
                }
                builder.append(curr);
                continue;
            }
            if (curr == '\\') {
                if (b + 1 >= string.length()) continue;
                builder.append(string.charAt(++b));
                continue;
            }
            if (id != null) {
                for (char argumentWrapper : this.argumentWrappers()) {
                    if (curr != argumentWrapper) continue;
                    builder.append(curr);
                    wrapper = curr;
                    continue block0;
                }
            }
            if (id == null && this.hasArgument() && (arg = this.matchArgument(string, b)) <= 0) {
                matched = false;
                arg = 0;
            }
            int end = 0;
            if (arg == 0) {
                matched = true;
                end = this.matchEnd(string, b);
                if (end <= 0) {
                    matched = false;
                    end = 0;
                }
            }
            if (matched) {
                String str = builder.toString();
                if (id == null) {
                    if (!provider.isValidTag(str, context)) return null;
                    id = str;
                    builder = new StringBuilder();
                    if (end != 0) return new TagLikeParser.Format.Tag(start, b + end, id, argument);
                    continue;
                }
                argument = str;
                return new TagLikeParser.Format.Tag(start, b + end, id, argument);
            }
            builder.append(curr);
        }
        return null;
    }

    public char[] argumentWrappers();

    public int endLength();

    public boolean hasArgument();
}

