/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EMFModel_ID
implements Comparable<EMFModel_ID> {
    public String namespace = "minecraft";
    private String fileName;
    private String mapId;
    private final List<FallbackModel> fallBackModels;

    public EMFModel_ID(String both) {
        this(both, null);
    }

    public EMFModel_ID(String both, String mapId) {
        this(both, mapId, new ArrayList<FallbackModel>());
    }

    private EMFModel_ID(String both, String mapId, List<FallbackModel> fallBackModels) {
        this.fileName = both;
        this.mapId = mapId;
        this.fallBackModels = fallBackModels;
    }

    public EMFModel_ID setFileName(String fileName) {
        if (fileName.contains(":")) {
            String[] split = fileName.split(":");
            if (split.length == 2) {
                this.namespace = split[0];
                this.fileName = split[1];
            } else {
                this.fileName = fileName;
            }
        } else {
            this.fileName = fileName;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EMFModel_ID that = (EMFModel_ID)o;
        return this.fileName.equals(that.fileName) && Objects.equals(this.mapId, that.mapId);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.mapId);
    }

    public String toString() {
        return this.fileName;
    }

    public EMFModel_ID setBoth(String both) {
        this.fileName = both;
        this.mapId = null;
        return this;
    }

    public boolean areBothSame() {
        return this.mapId == null || this.fileName.equals(this.mapId);
    }

    public EMFModel_ID setBoth(String fileName, String mapId) {
        this.fileName = fileName;
        this.mapId = mapId;
        return this;
    }

    public String getfileName() {
        return this.fileName;
    }

    public boolean hasFallbackModels() {
        return !this.fallBackModels.isEmpty();
    }

    public void forEachFallback(Consumer<EMFModel_ID> action) {
        EMFModel_ID fallbackModel = this;
        while (fallbackModel.hasFallbackModels()) {
            if ((fallbackModel = fallbackModel.getNextFallbackModel()) == null) {
                return;
            }
            action.accept(fallbackModel);
        }
    }

    @Nullable
    public EMFModel_ID getNextFallbackModel() {
        if (this.hasFallbackModels()) {
            FallbackModel next = this.fallBackModels.get(0);
            EMFModel_ID second = new EMFModel_ID(next.fileName, this.getMapId(), this.fallBackModels.subList(1, this.fallBackModels.size()));
            second.namespace = next.namespace == null ? this.namespace : next.namespace;
            return second;
        }
        return null;
    }

    public EMFModel_ID addFallbackModel(String namespace, String fileName) {
        this.fallBackModels.add(new FallbackModel(namespace, fileName));
        return this;
    }

    public EMFModel_ID addFallbackModel(String fileName) {
        return this.addFallbackModel(this.namespace, fileName);
    }

    public EMFModel_ID setMapIdAndAddFallbackModel(String both) {
        return this.setMapIdAndAddFallbackModel(both, both);
    }

    public EMFModel_ID setMapIdAndAddFallbackModel(String mapId, String fileName) {
        this.mapId = mapId;
        if (fileName.contains(":")) {
            String[] split = fileName.split(":");
            if (split.length == 2) {
                this.addFallbackModel(split[0], split[1]);
            } else {
                this.addFallbackModel(fileName);
            }
        } else {
            this.addFallbackModel(fileName);
        }
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void finishAndPrepAutomatedFallbacks() {
        String[] split;
        if (this.getfileName().contains(":") && (split = this.fileName.split(":")).length == 2) {
            this.assertNamespaceAndCreateDeprecatedModdedFileName(split[0], split[1]);
        }
        if (!"minecraft".equals(this.namespace)) {
            this.assertNamespaceAndCreateDeprecatedModdedFileName(this.namespace, this.fileName);
        }
        if (this.fileName.endsWith("_armor")) {
            if (this.fileName.endsWith("_baby_inner_armor")) {
                this.addFallbackModel("baby_inner_armor");
            } else if (this.fileName.endsWith("_baby_outer_armor")) {
                this.addFallbackModel("baby_outer_armor");
            }
            if (this.fileName.endsWith("_inner_armor")) {
                this.addFallbackModel("inner_armor");
            } else if (this.fileName.endsWith("_outer_armor")) {
                this.addFallbackModel("outer_armor");
            }
        }
    }

    private void assertNamespaceAndCreateDeprecatedModdedFileName(String namespace, String fileName) {
        this.namespace = namespace;
        this.fileName = fileName;
        this.addFallbackModel("minecraft", "modded/" + namespace + "/" + fileName);
    }

    public String getMapId() {
        String namespace = this.getNamespace().equals("minecraft") ? "" : this.getNamespace() + ":";
        return namespace + (this.mapId == null ? this.fileName : this.mapId);
    }

    @Override
    public int compareTo(@NotNull EMFModel_ID o) {
        return this.getfileName().compareTo(o.getfileName());
    }

    public String getDisplayFileName() {
        if (this.fileName.startsWith("modded/")) {
            return this.fileName + ".jem";
        }
        return "assets/" + this.namespace + "/optifine/cem/" + this.fileName + ".jem";
    }

    private record FallbackModel(String namespace, String fileName) {
    }
}

