/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.client.JourneymapClient;
import journeymap.client.event.handlers.ChunkMonitorHandler;
import journeymap.client.event.handlers.HudOverlayHandler;
import journeymap.client.event.handlers.KeyEventHandler;
import journeymap.client.event.handlers.PlayerConnectHandler;
import journeymap.client.event.handlers.ScreenEventHandler;
import journeymap.client.event.handlers.StateTickHandler;
import journeymap.client.event.handlers.WaypointBeaconHandler;
import journeymap.client.event.handlers.WorldEventHandler;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class FabricEventHandlerManager {
    private static FabricEventHandlerManager INSTANCE;
    private final WorldEventHandler worldEventHandler = new WorldEventHandler();
    private final WaypointBeaconHandler waypointBeaconHandler = new WaypointBeaconHandler();
    private final StateTickHandler stateTickHandler = new StateTickHandler();
    private final PlayerConnectHandler playerConnectHandler = new PlayerConnectHandler();
    private final HudOverlayHandler hudOverlayHandler = HudOverlayHandler.getInstance();
    private final ChunkMonitorHandler chunkMonitorHandler = ChunkMonitorHandler.getInstance();
    private final KeyEventHandler keyEventHandler = JourneymapClient.getInstance().getKeyEvents().getHandler();

    private FabricEventHandlerManager() {
        this.registerFabricEvents();
    }

    private void registerFabricEvents() {
        AtomicBoolean registered = new AtomicBoolean(false);
        ClientTickEvents.END_CLIENT_TICK.register(listener -> this.stateTickHandler.onClientTick());
        WorldRenderEvents.AFTER_TRANSLUCENT.register(ctx -> {
            if (JourneymapClient.getInstance().getWaypointProperties().shaderBeacon.get().booleanValue() || class_310.method_29611()) {
                FabricEventHandlerManager.getInstance().onRenderWorldLastEvent(ctx.matrixStack(), true);
            }
        });
        WorldRenderEvents.LAST.register(ctx -> FabricEventHandlerManager.getInstance().onRenderWorldLastEvent(ctx.matrixStack(), false));
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (!class_310.method_1551().field_1705.method_53531().method_53536()) {
                this.hudOverlayHandler.onRenderOverlay(drawContext);
            }
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> ScreenEvents.beforeRender((class_437)screen).register(this::onScreenRenderPreEvent));
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            ScreenMouseEvents.allowMouseClick((class_437)screen).register(this::onScreenMousePressedEvent);
            ScreenMouseEvents.beforeMouseRelease((class_437)screen).register(this::onScreenMouseReleasedEvent);
            ScreenEvents.remove((class_437)screen).register(this::onScreenClosedEvent);
            ScreenKeyboardEvents.allowKeyPress((class_437)screen).register((keyScreen, keyX, keyY, button) -> {
                if (keyScreen != null) {
                    return !this.keyEventHandler.onGuiKeyboardEvent(keyScreen, keyX);
                }
                return true;
            });
            ScreenMouseEvents.afterMouseClick((class_437)screen).register((mouseScreen, mouseX, mouseY, button) -> {
                if (mouseScreen != null) {
                    this.keyEventHandler.onMouseEvent(button, mouseScreen);
                }
            });
        });
    }

    public static FabricEventHandlerManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FabricEventHandlerManager();
        }
        return INSTANCE;
    }

    public void onWorldUnload(class_1936 world) {
        this.worldEventHandler.onUnload(world);
    }

    public void onRenderWorldLastEvent(class_4587 poseStack, boolean onlyBeacon) {
        this.waypointBeaconHandler.onRenderWaypoints(poseStack, onlyBeacon);
    }

    public void onScreenRenderPreEvent(class_437 screen, class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        ScreenEventHandler.getInstance().onScreenPreRender(screen, graphics, mouseX, mouseY);
    }

    public boolean onScreenMousePressedEvent(class_437 screen, double mouseX, double mouseY, int button) {
        return !ScreenEventHandler.getInstance().onScreenMousePressedEvent(screen, mouseX, mouseY, button);
    }

    public boolean onScreenMouseDraggedEvent(class_437 screen, double mouseX, double mouseY, double dragX, double dragY, int mouseButton) {
        return ScreenEventHandler.getInstance().onScreenMouseDraggedEvent(screen, mouseX, mouseY, dragX, dragY, mouseButton);
    }

    public boolean onScreenMouseReleasedEvent(class_437 screen, double mouseX, double mouseY, int button) {
        return ScreenEventHandler.getInstance().onScreenMouseReleasedEvent(screen, mouseX, mouseY, button);
    }

    public void onScreenClosedEvent(class_437 screen) {
        ScreenEventHandler.getInstance().onScreenClosedEvent(screen);
    }

    public void onPlayerConnect(class_310 minecraft) {
        this.playerConnectHandler.onConnect();
    }

    public void onRenderOverlayDebug(List<String> leftText) {
        this.hudOverlayHandler.onRenderOverlayDebug(leftText);
    }

    public void onBlockUpdate(class_1936 world, class_2338 pos) {
        this.chunkMonitorHandler.onBlockUpdate(world, pos);
    }

    public void onChunkUpdate(class_1936 world, class_1923 pos) {
        this.chunkMonitorHandler.onChunkUpdate(world, pos);
    }

    public void onChunkLoad(class_1936 world, class_2791 chunkAccess) {
        this.chunkMonitorHandler.onChunkLoad(world, chunkAccess);
    }

    public void keyPressEvent(int key) {
        this.keyEventHandler.onGameKeyboardEvent(key);
    }

    public void mouseEvent(int key) {
        this.keyEventHandler.onMouseEvent(key, class_310.method_1551().field_1755);
    }
}

