/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.api.client.impl.ClientAPI;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.io.FileHandler;
import journeymap.client.log.StatTimer;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.EntityHelper;
import journeymap.client.model.MapType;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.InGameMapProperties;
import journeymap.client.properties.MapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.draw.RadarDrawStepFactory;
import journeymap.client.render.draw.WaypointDrawStepFactory;
import journeymap.client.render.map.Renderer;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.IntegerField;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;

public class MapState {
    public final int minZoom;
    public final int maxZoom = 16384;
    public AtomicBoolean follow = new AtomicBoolean(true);
    public String playerLastPos = "0,0";
    private StatTimer refreshTimer = StatTimer.get("MapState.refresh");
    private StatTimer generateDrawStepsTimer = StatTimer.get("MapState.generateDrawSteps");
    private MapType lastMapType;
    private File worldDir = null;
    private long lastRefresh = 0L;
    private long lastMapTypeChange = 0L;
    private IntegerField lastSlice = new IntegerField(Category.Hidden, "", -4, 15, 4);
    private boolean surfaceMappingAllowed = false;
    private boolean caveMappingAllowed = false;
    private boolean caveMappingEnabled = false;
    private boolean topoMappingAllowed = false;
    private boolean biomeMappingAllowed = false;
    private List<DrawStep> drawStepList = new ArrayList<DrawStep>();
    private List<DrawWayPointStep> drawWaypointStepList = new ArrayList<DrawWayPointStep>();
    private String playerBiome = "";
    private InGameMapProperties lastMapProperties = null;
    private List<EntityDTO> entityList = new ArrayList<EntityDTO>(32);
    private int lastPlayerChunkX = 0;
    private int lastPlayerChunkY = 0;
    private int lastPlayerChunkZ = 0;
    private String lastWorldName;
    private boolean forceRefreshState = false;

    public MapState() {
        this.minZoom = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(class_310 mc, class_1657 player, InGameMapProperties mapProperties) {
        class_638 world = mc.field_1687;
        if (world == null || world.method_8597() == null) {
            return;
        }
        this.refreshTimer.start();
        try {
            CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
            this.lastMapProperties = mapProperties;
            if (!FileHandler.getWorldDirectoryName(mc).equals(this.lastWorldName)) {
                this.worldDir = FileHandler.getJMWorldDir(mc);
                this.lastWorldName = FileHandler.getWorldDirectoryName(mc);
            }
            int dimHeight = Math.max(world.method_8597().comp_652(), world.method_8597().comp_653());
            if (world != null && this.lastSlice.getMaxValue() != dimHeight / 16 - 1) {
                int maxSlice = dimHeight / 16 - 1;
                int minSlice = world.method_8597().comp_651() / 16;
                int seaLevel = Math.round(world.method_8615() >> 4);
                int currentSlice = this.lastSlice.get();
                this.lastSlice = new IntegerField(Category.Hidden, "", minSlice, maxSlice, seaLevel);
                this.lastSlice.set((Object)currentSlice);
            }
            this.caveMappingAllowed = FeatureManager.getInstance().isAllowed(Feature.MapCaves);
            this.caveMappingEnabled = this.caveMappingAllowed && mapProperties.showCaves.get() != false;
            this.surfaceMappingAllowed = FeatureManager.getInstance().isAllowed(Feature.MapSurface);
            this.topoMappingAllowed = FeatureManager.getInstance().isAllowed(Feature.MapTopo) && coreProperties.mapTopography.get() != false;
            this.biomeMappingAllowed = FeatureManager.getInstance().isAllowed(Feature.MapBiome) && coreProperties.mapBiome.get() != false;
            this.lastPlayerChunkX = player.method_31476().field_9181;
            this.lastPlayerChunkY = player.method_31478() >> 4;
            this.lastPlayerChunkZ = player.method_31476().field_9180;
            EntityDTO playerDTO = DataCache.getPlayer();
            this.playerBiome = playerDTO.biome;
            if (this.lastMapType != null) {
                if (player.method_37908().method_27983() != this.lastMapType.dimension) {
                    this.lastMapType = null;
                } else if (this.caveMappingEnabled && this.follow.get() && playerDTO.underground.booleanValue() && !this.lastMapType.isUnderground()) {
                    this.lastMapType = null;
                } else if (this.caveMappingEnabled && this.follow.get() && !playerDTO.underground.booleanValue() && this.lastMapType.isUnderground()) {
                    this.lastMapType = null;
                } else if (!this.lastMapType.isAllowed()) {
                    this.lastMapType = null;
                }
            }
            this.lastMapType = this.getMapType();
            this.updateLastRefresh();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error refreshing MapState: " + LogFormatter.toPartialString(e));
        }
        finally {
            this.refreshTimer.stop();
        }
    }

    public MapType setMapType(MapType.Name mapTypeName) {
        return this.setMapType(MapType.from(mapTypeName, DataCache.getPlayer()));
    }

    public MapType toggleMapType() {
        MapType.Name next = this.getNextMapType(this.getMapType().name);
        return this.setMapType(next);
    }

    public MapType.Name getNextMapType(MapType.Name name) {
        EntityDTO player = DataCache.getPlayer();
        class_1297 playerEntity = (class_1297)player.entityRef.get();
        if (playerEntity == null) {
            return name;
        }
        ArrayList<MapType.Name> types = new ArrayList<MapType.Name>(4);
        if (this.surfaceMappingAllowed) {
            types.add(MapType.Name.day);
            types.add(MapType.Name.night);
        }
        if (this.caveMappingAllowed && (player.underground.booleanValue() || name == MapType.Name.underground)) {
            types.add(MapType.Name.underground);
        }
        if (this.topoMappingAllowed) {
            types.add(MapType.Name.topo);
        }
        if (this.biomeMappingAllowed) {
            types.add(MapType.Name.biome);
        }
        if (name == MapType.Name.none && !types.isEmpty()) {
            return (MapType.Name)((Object)types.get(0));
        }
        if (types.contains((Object)name)) {
            Iterator cyclingIterator = Iterables.cycle(types).iterator();
            while (cyclingIterator.hasNext()) {
                MapType.Name current = (MapType.Name)((Object)cyclingIterator.next());
                if (current != name) continue;
                return (MapType.Name)((Object)cyclingIterator.next());
            }
        }
        return name;
    }

    public MapType setMapType(MapType mapType) {
        if (!mapType.isAllowed() && !(mapType = MapType.from(this.getNextMapType(mapType.name), DataCache.getPlayer())).isAllowed()) {
            mapType = MapType.none();
        }
        EntityDTO player = DataCache.getPlayer();
        if (player.underground.booleanValue() != mapType.isUnderground()) {
            this.follow.set(false);
        }
        if (mapType.isUnderground()) {
            if (player.chunkCoordY != mapType.vSlice) {
                this.follow.set(false);
            }
            this.lastSlice.set(mapType.vSlice);
        } else if (this.lastMapProperties != null && mapType.name != MapType.Name.none && this.lastMapProperties.preferredMapType.get() != mapType.name) {
            this.lastMapProperties.preferredMapType.set(mapType.name);
            this.lastMapProperties.save();
        }
        this.setLastMapTypeChange(mapType);
        return this.lastMapType;
    }

    public MapType getMapType() {
        if (this.lastMapType == null) {
            EntityDTO player = DataCache.getPlayer();
            MapType mapType = null;
            try {
                if (this.caveMappingEnabled && player.underground.booleanValue()) {
                    mapType = MapType.underground(player);
                } else if (this.follow.get()) {
                    if (this.surfaceMappingAllowed && !player.underground.booleanValue()) {
                        mapType = MapType.day(player);
                    } else if (this.topoMappingAllowed && !player.underground.booleanValue()) {
                        mapType = MapType.topo(player);
                    } else if (this.biomeMappingAllowed && !player.underground.booleanValue()) {
                        mapType = MapType.biome(player);
                    }
                }
                if (mapType == null) {
                    mapType = MapType.from((MapType.Name)((Object)this.lastMapProperties.preferredMapType.get()), player);
                }
            }
            catch (Exception e) {
                mapType = MapType.day(player);
            }
            this.setMapType(mapType);
        }
        return this.lastMapType;
    }

    public long getLastMapTypeChange() {
        return this.lastMapTypeChange;
    }

    private void setLastMapTypeChange(MapType mapType) {
        if (!Objects.equal((Object)mapType, (Object)this.lastMapType)) {
            this.lastMapTypeChange = System.currentTimeMillis();
            this.requireRefresh();
        }
        this.lastMapType = mapType;
    }

    public boolean isUnderground() {
        return this.getMapType().isUnderground();
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    public String getPlayerBiome() {
        return this.playerBiome;
    }

    public List<? extends DrawStep> getDrawSteps() {
        return this.drawStepList;
    }

    public List<DrawWayPointStep> getDrawWaypointSteps() {
        return this.drawWaypointStepList;
    }

    public void generateDrawSteps(class_310 mc, Renderer renderer, WaypointDrawStepFactory waypointRenderer, RadarDrawStepFactory radarRenderer, InGameMapProperties mapProperties, boolean checkWaypointDistance) {
        this.generateDrawStepsTimer.start();
        this.lastMapProperties = mapProperties;
        this.drawStepList.clear();
        this.drawWaypointStepList.clear();
        this.entityList.clear();
        ClientAPI.INSTANCE.getDrawSteps(this.drawStepList, renderer.getUIState());
        if (FeatureManager.getInstance().isAllowed(Feature.RadarAnimals)) {
            if (mapProperties.showAnimals.get().booleanValue() || mapProperties.showPets.get().booleanValue()) {
                this.entityList.addAll(DataCache.INSTANCE.getAnimals(false).values());
            }
            if (mapProperties.showAmbientCreatures.get().booleanValue()) {
                this.entityList.addAll(DataCache.INSTANCE.getAmbientCreatures(false).values());
            }
        }
        if (FeatureManager.getInstance().isAllowed(Feature.RadarVillagers) && mapProperties.showVillagers.get().booleanValue()) {
            this.entityList.addAll(DataCache.INSTANCE.getVillagers(false).values());
        }
        if (FeatureManager.getInstance().isAllowed(Feature.RadarMobs) && mapProperties.showMobs.get().booleanValue()) {
            this.entityList.addAll(DataCache.INSTANCE.getMobs(false).values());
        }
        if (FeatureManager.getInstance().isAllowed(Feature.RadarPlayers) && mapProperties.showPlayers.get().booleanValue()) {
            mc.field_1724.method_37908().method_18456();
            Collection<EntityDTO> cachedPlayers = DataCache.INSTANCE.getPlayers(false).values();
            if (cachedPlayers.size() != mc.method_1562().method_2880().size()) {
                cachedPlayers = DataCache.INSTANCE.getPlayers(true).values();
            }
            this.entityList.addAll(cachedPlayers);
        }
        if (!this.entityList.isEmpty()) {
            Collections.sort(this.entityList, EntityHelper.entityMapComparator);
            this.drawStepList.addAll(radarRenderer.prepareSteps(this.entityList, renderer, mapProperties));
        }
        if (mapProperties.showWaypoints.get().booleanValue()) {
            boolean showLabel = mapProperties.showWaypointLabels.get();
            this.drawWaypointStepList.addAll(waypointRenderer.prepareSteps(DataCache.INSTANCE.getWaypoints(false), renderer, checkWaypointDistance, showLabel));
        }
        this.generateDrawStepsTimer.stop();
    }

    public boolean minimapZoomIn() {
        if (this.lastMapProperties.zoomLevel.get() < 16384) {
            return this.setZoom(this.lastMapProperties.zoomLevel.get() * 2);
        }
        return false;
    }

    public boolean minimapZoomOut() {
        if (this.lastMapProperties.zoomLevel.get() > 256) {
            return this.setZoom(this.lastMapProperties.zoomLevel.get() / 2);
        }
        return false;
    }

    public boolean setZoom(int zoom) {
        if (zoom > 16384 || zoom < this.minZoom || zoom == this.lastMapProperties.zoomLevel.get()) {
            return false;
        }
        this.lastMapProperties.zoomLevel.set((Object)zoom);
        this.requireRefresh();
        return true;
    }

    public int getZoom() {
        return this.lastMapProperties.zoomLevel.get();
    }

    public void requireRefresh() {
        this.lastRefresh = 0L;
    }

    public void updateLastRefresh() {
        this.lastRefresh = System.currentTimeMillis();
    }

    public boolean shouldRefresh(class_310 mc, MapProperties mapProperties) {
        if (ClientAPI.INSTANCE.isDrawStepsUpdateNeeded()) {
            return true;
        }
        if (MapPlayerTask.getlastTaskCompleted() - this.lastRefresh > 500L) {
            return true;
        }
        if (this.lastMapType == null) {
            return true;
        }
        EntityDTO player = DataCache.getPlayer();
        if (!player.dimension.equals(this.getMapType().dimension)) {
            return true;
        }
        double d0 = this.lastPlayerChunkX - player.chunkCoordX;
        double d1 = this.lastPlayerChunkY - player.chunkCoordY;
        double d2 = this.lastPlayerChunkZ - player.chunkCoordZ;
        double diff = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        if (diff > 2.0) {
            return true;
        }
        if (this.lastMapProperties == null || !this.lastMapProperties.equals(mapProperties)) {
            return true;
        }
        if (this.forceRefreshState) {
            this.forceRefreshState = false;
            return true;
        }
        return false;
    }

    public void setForceRefreshState(boolean force) {
        this.forceRefreshState = force;
    }

    public boolean isCaveMappingAllowed() {
        return this.caveMappingAllowed;
    }

    public boolean isCaveMappingEnabled() {
        return this.caveMappingEnabled;
    }

    public boolean isSurfaceMappingAllowed() {
        return this.surfaceMappingAllowed;
    }

    public boolean isTopoMappingAllowed() {
        return this.topoMappingAllowed;
    }

    public class_5321<class_1937> getDimension() {
        return this.getMapType().dimension;
    }

    public IntegerField getLastSlice() {
        return this.lastSlice;
    }

    public void resetMapType() {
        this.lastMapType = null;
    }

    public boolean isBiomeMappingAllowed() {
        return this.biomeMappingAllowed;
    }
}

