/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import journeymap.api.v2.client.display.Context;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.model.EntityDTO;
import journeymap.client.render.RegionTileShaders;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;

public class MapType {
    public final Integer vSlice;
    public final Name name;
    public final class_5321<class_1937> dimension;
    public final Context.MapType apiMapType;
    private final int theHashCode;
    private final String theCacheKey;

    public MapType(Name name, Integer vSlice, class_5321<class_1937> dimension) {
        vSlice = name != Name.underground ? null : vSlice;
        this.name = name;
        this.vSlice = vSlice;
        this.dimension = dimension;
        this.apiMapType = this.toApiContextMapType(name);
        this.theCacheKey = MapType.toCacheKey(name, vSlice, dimension);
        this.theHashCode = this.theCacheKey.hashCode();
    }

    public static MapType from(Name name, Integer vSlice, class_5321<class_1937> dimension) {
        return DataCache.INSTANCE.getMapType(name, vSlice, dimension);
    }

    public static MapType from(Integer vSlice, class_5321<class_1937> dimension) {
        return MapType.from(vSlice == null ? Name.surface : Name.underground, vSlice, dimension);
    }

    public static MapType from(Name name, EntityDTO player) {
        return MapType.from(name, player.chunkCoordY, player.dimension);
    }

    public static MapType day(class_5321<class_1937> dimension) {
        return MapType.from(Name.day, null, dimension);
    }

    public static MapType day(EntityDTO player) {
        return MapType.from(Name.day, null, player.dimension);
    }

    public static MapType night(class_5321<class_1937> dimension) {
        return MapType.from(Name.night, null, dimension);
    }

    public static MapType night(EntityDTO player) {
        return MapType.from(Name.night, null, player.dimension);
    }

    public static MapType topo(class_5321<class_1937> dimension) {
        return MapType.from(Name.topo, null, dimension);
    }

    public static MapType topo(EntityDTO player) {
        return MapType.from(Name.topo, null, player.dimension);
    }

    public static MapType underground(EntityDTO player) {
        return MapType.from(Name.underground, player.chunkCoordY, player.dimension);
    }

    public static MapType biome(EntityDTO player) {
        return MapType.from(Name.biome, null, player.dimension);
    }

    public static MapType biome(class_5321<class_1937> dimension) {
        return MapType.from(Name.biome, null, dimension);
    }

    public static MapType underground(Integer vSlice, class_5321<class_1937> dimension) {
        return MapType.from(Name.underground, vSlice, dimension);
    }

    public static MapType none() {
        return MapType.from(Name.none, 0, (class_5321<class_1937>)class_1937.field_25179);
    }

    public static String toCacheKey(Name name, Integer vSlice, class_5321<class_1937> dimension) {
        return String.format("%s|%s|%s", new Object[]{DimensionHelper.getDimName(dimension), name, vSlice == null ? "_" : vSlice});
    }

    private Context.MapType toApiContextMapType(Name name) {
        return switch (name.ordinal()) {
            case 1 -> Context.MapType.Day;
            case 5 -> Context.MapType.Topo;
            case 2 -> Context.MapType.Night;
            case 3 -> Context.MapType.Underground;
            case 6 -> Context.MapType.Biome;
            default -> Context.MapType.Day;
        };
    }

    public static MapType fromApiContextMapType(Context.MapType apiMapType, Integer vSlice, class_5321<class_1937> dimension) {
        switch (apiMapType) {
            case Night: {
                return new MapType(Name.night, vSlice, dimension);
            }
            case Underground: {
                return new MapType(Name.underground, vSlice, dimension);
            }
            case Topo: {
                return new MapType(Name.topo, vSlice, dimension);
            }
            case Biome: {
                return new MapType(Name.biome, vSlice, dimension);
            }
        }
        return new MapType(Name.day, vSlice, dimension);
    }

    public String toCacheKey() {
        return this.theCacheKey;
    }

    public String toString() {
        return this.theCacheKey;
    }

    public String name() {
        return this.name.name();
    }

    public boolean isUnderground() {
        return this.name == Name.underground;
    }

    public boolean isSurface() {
        return this.name == Name.surface;
    }

    public boolean isSurfaceType() {
        return this.name == Name.surface || this.name == Name.day || this.name == Name.night || this.name == Name.biome;
    }

    public boolean isDay() {
        return this.name == Name.day;
    }

    public boolean isNight() {
        return this.name == Name.night;
    }

    public boolean isTopo() {
        return this.name == Name.topo;
    }

    public boolean isBiome() {
        return this.name == Name.biome;
    }

    public boolean isDayOrNight() {
        return this.name == Name.day || this.name == Name.night;
    }

    public boolean isAllowed() {
        if (this.isUnderground()) {
            return FeatureManager.getInstance().isAllowed(Feature.MapCaves);
        }
        if (this.isTopo()) {
            return FeatureManager.getInstance().isAllowed(Feature.MapTopo);
        }
        if (this.isDayOrNight() || this.isSurface()) {
            return FeatureManager.getInstance().isAllowed(Feature.MapSurface);
        }
        if (this.isBiome()) {
            return FeatureManager.getInstance().isAllowed(Feature.MapBiome);
        }
        return this.name == Name.none;
    }

    public int hashCode() {
        return this.theHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapType mapType = (MapType)o;
        if (this.dimension != mapType.dimension) {
            return false;
        }
        if (this.name != mapType.name) {
            return false;
        }
        return !(this.vSlice != null ? !this.vSlice.equals(mapType.vSlice) : mapType.vSlice != null);
    }

    public String getShader() {
        switch (this.name.ordinal()) {
            case 2: {
                return RegionTileShaders.from(JourneymapClient.getInstance().getCoreProperties().nightShader.get());
            }
            case 3: {
                if (class_1937.field_25180 == class_310.method_1551().field_1724.method_37908().method_27983()) {
                    return RegionTileShaders.from(JourneymapClient.getInstance().getCoreProperties().netherShader.get());
                }
                return RegionTileShaders.from(JourneymapClient.getInstance().getCoreProperties().caveShader.get());
            }
            case 5: {
                return RegionTileShaders.from(JourneymapClient.getInstance().getCoreProperties().topoShader.get());
            }
            case 6: {
                return RegionTileShaders.from(JourneymapClient.getInstance().getCoreProperties().biomeShader.get());
            }
        }
        return RegionTileShaders.from(JourneymapClient.getInstance().getCoreProperties().dayShader.get());
    }

    public static enum Name {
        any("jm.common.map_type.any"),
        day("jm.common.map_type.day"),
        night("jm.common.map_type.night"),
        underground("jm.common.map_type.underground"),
        surface("jm.common.map_type.surface"),
        topo("jm.common.map_type.topo"),
        biome("jm.common.map_type.biome"),
        none("jm.common.map_type.none");

        String key;

        private Name(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

