/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import journeymap.client.Constants;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColorPalette;
import journeymap.client.ui.colorpalette.ColorPaletteScreen;
import journeymap.client.ui.colorpalette.CopyPalettePopup;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.popupscreenbutton.simple.ConfirmationPopup;
import journeymap.client.ui.component.screens.JmUI;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_7842;
import net.minecraft.class_7852;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class ColorPaletteManagerScreen
extends JmUI {
    private static final class_2960 BACKGROUND_SPRITE = class_2960.method_60654((String)"popup/background");
    private final class_2561 labelBlocks = class_2561.method_43471((String)"jm.colorpalette.total_blocks");
    private final class_2561 labelStates = class_2561.method_43471((String)"jm.colorpalette.total_states");
    private final class_2561 labelBiomes = class_2561.method_43471((String)"jm.colorpalette.total_biomes");
    private final class_2561 labelClose = class_2561.method_43471((String)"jm.common.close");
    ColorPaletteScreen colorPaletteScreen;
    Palette globalPalette;
    Palette worldPalette;

    public ColorPaletteManagerScreen(ColorPaletteScreen returnDisplay) {
        super(Constants.getString("jm.colorpalette.manage_palettes_title"), true, returnDisplay);
        this.colorPaletteScreen = returnDisplay;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        class_8667 linearLayout = class_8667.method_52741();
        linearLayout.method_52735(6).method_52740().method_46467();
        ColorPalette defaultPalette = ColorManager.INSTANCE.getDefaultPalette();
        linearLayout.method_52736((class_8021)new class_7842((class_2561)this.labelBlocks.method_27661().method_27693(String.valueOf(defaultPalette.blockCount())), this.field_22793));
        linearLayout.method_52736((class_8021)new class_7842((class_2561)this.labelStates.method_27661().method_27693(String.valueOf(defaultPalette.stateCount())), this.field_22793));
        linearLayout.method_52736((class_8021)new class_7842((class_2561)this.labelBiomes.method_27661().method_27693(String.valueOf(defaultPalette.biomeCount())), this.field_22793));
        linearLayout.method_52736((class_8021)new class_7852(0, 10));
        class_8667 paletteLayout = class_8667.method_52742();
        paletteLayout.method_52735(46).method_52740().method_46472();
        this.globalPalette = (Palette)paletteLayout.method_52736((class_8021)new Palette(ColorManager.INSTANCE.getGlobalPalette(), this.field_22793, this));
        this.worldPalette = (Palette)paletteLayout.method_52736((class_8021)new Palette(ColorManager.INSTANCE.getWorldPalette(), this.field_22793, this));
        linearLayout.method_52736((class_8021)paletteLayout);
        linearLayout.method_52736((class_8021)new class_7852(0, 8));
        this.contentLayout.method_46441((class_8021)linearLayout);
        this.footerLayout.method_52736((class_8021)Button.method_46430((class_2561)this.labelClose, b -> this.closeAndReturn()).method_46432(this.field_22793.method_27525((class_5348)this.labelClose) + 10).method_46431());
    }

    @Override
    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(graphics);
        graphics.method_52706(class_1921::method_62277, BACKGROUND_SPRITE, this.globalPalette.method_46426() - 16, this.globalPalette.method_46427() - 16, this.globalPalette.method_25368() + 32, this.globalPalette.method_25364() + 32);
        graphics.method_52706(class_1921::method_62277, BACKGROUND_SPRITE, this.worldPalette.method_46426() - 16, this.worldPalette.method_46427() - 16, this.worldPalette.method_25368() + 32, this.worldPalette.method_25364() + 32);
    }

    private void deleteAll(ColorPalette.Type type) {
        ColorPalette palette = type == ColorPalette.Type.Global ? ColorManager.INSTANCE.getGlobalPalette() : ColorManager.INSTANCE.getWorldPalette();
        palette.clear();
        this.colorPaletteScreen.setRemapNeeded();
        this.method_41843();
    }

    private void fillWithDefault(ColorPalette.Type type) {
        ColorPalette palette = type == ColorPalette.Type.Global ? ColorManager.INSTANCE.getGlobalPalette() : ColorManager.INSTANCE.getWorldPalette();
        palette.copyNonExistingFromPalette(ColorManager.INSTANCE.getDefaultPalette());
        this.method_41843();
    }

    private void copyPalette(CopyPalettePopup.Mode mode, boolean globalToWorld) {
        ColorPalette global = ColorManager.INSTANCE.getGlobalPalette();
        ColorPalette world = ColorManager.INSTANCE.getWorldPalette();
        if (world == null) {
            return;
        }
        switch (mode) {
            case CopyAllAndReplace: {
                if (globalToWorld) {
                    world.copyAllFromPalette(global);
                    break;
                }
                global.copyAllFromPalette(world);
                break;
            }
            case CopyExistingAndReplace: {
                if (globalToWorld) {
                    world.copyExistingFromPalette(global);
                    break;
                }
                global.copyExistingFromPalette(world);
                break;
            }
            default: {
                if (globalToWorld) {
                    world.copyNonExistingFromPalette(global);
                    break;
                }
                global.copyNonExistingFromPalette(world);
            }
        }
        this.colorPaletteScreen.setRemapNeeded();
        this.method_41843();
    }

    static class Palette
    extends class_8667 {
        private final class_2561 labelGlobal = class_2561.method_43471((String)"jm.colorpalette.global").method_27692(class_124.field_1067);
        private final class_2561 labelWorld = class_2561.method_43471((String)"jm.colorpalette.world").method_27692(class_124.field_1067);
        private final class_2561 labelBlocks = class_2561.method_43471((String)"jm.colorpalette.blocks");
        private final class_2561 labelStates = class_2561.method_43471((String)"jm.colorpalette.states");
        private final class_2561 labelBiomes = class_2561.method_43471((String)"jm.colorpalette.biomes");
        private final String deleteLabel = Constants.getString("jm.colorpalette.delete_all");
        private final String labelCopyToRight = "  " + Constants.getString("jm.colorpalette.copy") + " >";
        private final String labelCopyToLeft = "< " + Constants.getString("jm.colorpalette.copy") + "  ";
        private final String fillDefaultLabel = Constants.getString("jm.colorpalette.fill_default");
        private final ColorPalette colorPalette;
        private final ColorPaletteManagerScreen screen;

        public Palette(ColorPalette colorPalette, class_327 font, ColorPaletteManagerScreen screen) {
            super(0, 0, class_8667.class_8668.field_45404);
            this.colorPalette = colorPalette;
            this.screen = screen;
            super.method_52735(10).method_52740().method_46467();
            super.method_52736((class_8021)new class_7842(colorPalette.getType() == ColorPalette.Type.Global ? this.labelGlobal : this.labelWorld, font));
            class_8667 columns = class_8667.method_52742();
            columns.method_52735(10).method_52740().method_46474();
            super.method_52736((class_8021)columns);
            class_8667 dataColumn = class_8667.method_52741();
            dataColumn.method_52735(4).method_52740().method_46461();
            class_8667 buttonColumn = class_8667.method_52741().method_52735(4);
            if (colorPalette.getType().equals((Object)ColorPalette.Type.Global)) {
                columns.method_52736((class_8021)dataColumn);
                columns.method_52736((class_8021)buttonColumn);
            } else {
                columns.method_52736((class_8021)buttonColumn);
                columns.method_52736((class_8021)dataColumn);
            }
            dataColumn.method_52736((class_8021)new class_7842((class_2561)this.labelBlocks.method_27661().method_27693(String.valueOf(colorPalette.blockCount())), font));
            dataColumn.method_52736((class_8021)new class_7842((class_2561)this.labelStates.method_27661().method_27693(String.valueOf(colorPalette.stateCount())), font));
            dataColumn.method_52736((class_8021)new class_7842((class_2561)this.labelBiomes.method_27661().method_27693(String.valueOf(colorPalette.biomeCount())), font));
            String labelCopy = colorPalette.getType() == ColorPalette.Type.Global ? this.labelCopyToRight : this.labelCopyToLeft;
            int buttonWidth = Math.max(font.method_1727(labelCopy), font.method_1727(this.deleteLabel)) + 10;
            PopupButton copyButton = (PopupButton)buttonColumn.method_52736(new PopupButton<CopyPalettePopup.Mode>(buttonWidth, 0, labelCopy, CopyPalettePopup::new, this::copyPalette));
            PopupButton deleteButton = (PopupButton)buttonColumn.method_52736(new PopupButton<Boolean>(buttonWidth, 0, this.deleteLabel, () -> new ConfirmationPopup("jm.colorpalette.delete_all_dialog", "jm.colorpalette.delete_all", "jm.colorpalette.cancel"), this::deletePalette));
            if (!colorPalette.hasBlockStateColors() && !colorPalette.hasBiomeColors()) {
                copyButton.field_22763 = false;
                deleteButton.field_22763 = false;
            }
            super.method_52736(new PopupButton<Boolean>(font.method_1727(this.fillDefaultLabel) + 10, 0, this.fillDefaultLabel, () -> new ConfirmationPopup("jm.colorpalette.fill_default_dialog", "jm.colorpalette.fill_default", "jm.colorpalette.cancel"), this::fillFromDefaultPalette));
        }

        public void copyPalette(CopyPalettePopup.Mode mode) {
            if (mode != null) {
                this.screen.copyPalette(mode, this.colorPalette.getType() == ColorPalette.Type.Global);
            }
        }

        public void deletePalette(boolean delete) {
            if (delete) {
                this.screen.deleteAll(this.colorPalette.getType());
            }
        }

        public void fillFromDefaultPalette(boolean fill) {
            if (fill) {
                this.screen.fillWithDefault(this.colorPalette.getType());
            }
        }
    }
}

