/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.minimap;

import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import journeymap.api.v2.client.option.KeyedEnum;
import journeymap.client.Constants;
import journeymap.client.model.EntityDTO;
import journeymap.client.render.draw.MobIconCache;
import journeymap.client.texture.TextureCache;
import net.minecraft.class_1043;
import net.minecraft.class_2960;

public enum EntityDisplay implements KeyedEnum
{
    Dots("jm.common.entity_display.dots", TextureCache.MobDot, null, TextureCache.MobDotArrow, null),
    Icons("jm.common.entity_display.icons", null, null, null, null),
    OutlinedIcons("jm.common.entity_display.outlined_icons", null, null, null, null),
    DotsAndIcons("jm.common.entity_display.dots_and_icons", TextureCache.MobIcon, TextureCache.MobIconBG, TextureCache.MobIconArrow, TextureCache.MobIconArrowBG),
    DotsAndOutlinedIcons("jm.common.entity_display.dots_and_outlined_icons", TextureCache.MobIcon, TextureCache.MobIconBG, TextureCache.MobIconArrow, TextureCache.MobIconArrowBG);

    public final String key;
    private final class_2960 defaultTexture;
    private final class_2960 defaultBGTexture;
    private final class_2960 showHeadingTexture;
    private final class_2960 showHeadingBGTexture;

    private EntityDisplay(String key, class_2960 defaultTexture, class_2960 defaultBGTexture, class_2960 showHeadingTexture, class_2960 showHeadingBGTexture) {
        this.key = key;
        this.defaultTexture = defaultTexture;
        this.defaultBGTexture = defaultBGTexture;
        this.showHeadingTexture = showHeadingTexture;
        this.showHeadingBGTexture = showHeadingBGTexture;
    }

    public static class_1043 getLocatorTexture(EntityDisplay entityDisplay, boolean showHeading) {
        return TextureCache.getTexture(showHeading ? entityDisplay.showHeadingTexture : entityDisplay.defaultTexture);
    }

    public static class_1043 getLocatorBGTexture(EntityDisplay entityDisplay, boolean showHeading) {
        return TextureCache.getTexture(showHeading ? entityDisplay.showHeadingBGTexture : entityDisplay.defaultBGTexture);
    }

    public static class_1043 getEntityTexture(EntityDisplay entityDisplay, GameProfile profile) {
        switch (entityDisplay.ordinal()) {
            case 0: {
                return TextureCache.getTexture(TextureCache.MobDotChevron);
            }
        }
        if (!Strings.isNullOrEmpty((String)profile.getName())) {
            return TextureCache.getPlayerSkin(profile);
        }
        return null;
    }

    public static class_1043 getEntityTexture(EntityDisplay entityDisplay, EntityDTO dto) {
        class_1043 tex;
        if (entityDisplay != Dots && (tex = (class_1043)MobIconCache.getMobIcon(dto, entityDisplay == OutlinedIcons || entityDisplay == DotsAndOutlinedIcons).b()) != null) {
            return tex;
        }
        return TextureCache.getTexture(TextureCache.MobDotChevron);
    }

    public static boolean hasEntityIcon(EntityDisplay entityDisplay, EntityDTO dto) {
        return MobIconCache.getMobIcon(dto, entityDisplay == OutlinedIcons || entityDisplay == DotsAndOutlinedIcons) != null;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return Constants.getString(this.key);
    }

    public boolean isDots() {
        return this == Dots;
    }

    public boolean isOutlined() {
        return this == OutlinedIcons || this == DotsAndOutlinedIcons;
    }

    public EntityDisplay getDot() {
        if (this == Icons || this == OutlinedIcons || this == DotsAndIcons || this == DotsAndOutlinedIcons) {
            return Dots;
        }
        return this;
    }
}

