/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.util.collections;

import java.util.Arrays;

public class BitArray {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private final long[] words;
    private final int count;

    private static int align(int num, int alignment) {
        int additive = alignment - 1;
        int mask = ~additive;
        return num + additive & mask;
    }

    public BitArray(int count) {
        this.words = new long[BitArray.align(count, 64) >> 6];
        this.count = count;
    }

    public boolean get(int index) {
        return (this.words[BitArray.wordIndex(index)] & 1L << BitArray.bitIndex(index)) != 0L;
    }

    public void set(int index) {
        int n = BitArray.wordIndex(index);
        this.words[n] = this.words[n] | 1L << BitArray.bitIndex(index);
    }

    public void unset(int index) {
        int n = BitArray.wordIndex(index);
        this.words[n] = this.words[n] & (1L << BitArray.bitIndex(index) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void put(int index, boolean value) {
        int wordIndex = BitArray.wordIndex(index);
        int bitIndex = BitArray.bitIndex(index);
        long intValue = value ? 1L : 0L;
        this.words[wordIndex] = this.words[wordIndex] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) | intValue << bitIndex;
    }

    public void set(int startIdx, int endIdx) {
        int startWordIndex = BitArray.wordIndex(startIdx);
        int endWordIndex = BitArray.wordIndex(endIdx - 1);
        long firstWordMask = -1L << startIdx;
        long lastWordMask = -1L >>> -endIdx;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i] = -1L;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] | lastWordMask;
        }
    }

    public void unset(int startIdx, int endIdx) {
        int startWordIndex = BitArray.wordIndex(startIdx);
        int endWordIndex = BitArray.wordIndex(endIdx - 1);
        long firstWordMask = -1L << startIdx ^ 0xFFFFFFFFFFFFFFFFL;
        long lastWordMask = -1L >>> -endIdx ^ 0xFFFFFFFFFFFFFFFFL;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] & (firstWordMask & lastWordMask);
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] & firstWordMask;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i] = 0L;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] & lastWordMask;
        }
    }

    public void copy(BitArray src, int startIdx, int endIdx) {
        int startWordIndex = BitArray.wordIndex(startIdx);
        int endWordIndex = BitArray.wordIndex(endIdx - 1);
        long firstWordMask = -1L << startIdx;
        long lastWordMask = -1L >>> -endIdx;
        if (startWordIndex == endWordIndex) {
            long combinedMask = firstWordMask & lastWordMask;
            long invCombinedMask = combinedMask ^ 0xFFFFFFFFFFFFFFFFL;
            this.words[startWordIndex] = this.words[startWordIndex] & invCombinedMask | src.words[startWordIndex] & combinedMask;
        } else {
            long invFirstWordMask = firstWordMask ^ 0xFFFFFFFFFFFFFFFFL;
            long invLastWordMask = lastWordMask ^ 0xFFFFFFFFFFFFFFFFL;
            this.words[startWordIndex] = this.words[startWordIndex] & invFirstWordMask | src.words[startWordIndex] & firstWordMask;
            int length = endWordIndex - (startWordIndex + 1);
            if (length > 0) {
                System.arraycopy(src.words, startWordIndex + 1, this.words, startWordIndex + 1, length);
            }
            this.words[endWordIndex] = this.words[endWordIndex] & invLastWordMask | src.words[endWordIndex] & lastWordMask;
        }
    }

    public void copy(BitArray src, int index) {
        int wordIndex = BitArray.wordIndex(index);
        long invBitMask = 1L << BitArray.bitIndex(index);
        long bitMask = invBitMask ^ 0xFFFFFFFFFFFFFFFFL;
        this.words[wordIndex] = this.words[wordIndex] & bitMask | src.words[wordIndex] & invBitMask;
    }

    public void and(BitArray src, int startIdx, int endIdx) {
        int startWordIndex = BitArray.wordIndex(startIdx);
        int endWordIndex = BitArray.wordIndex(endIdx - 1);
        long firstWordMask = -1L << startIdx;
        long lastWordMask = -1L >>> -endIdx;
        if (startWordIndex == endWordIndex) {
            long combinedMask = firstWordMask & lastWordMask;
            long invCombinedMask = combinedMask ^ 0xFFFFFFFFFFFFFFFFL;
            int n = startWordIndex;
            this.words[n] = this.words[n] & (src.words[startWordIndex] | invCombinedMask);
        } else {
            long invFirstWordMask = firstWordMask ^ 0xFFFFFFFFFFFFFFFFL;
            long invLastWordMask = lastWordMask ^ 0xFFFFFFFFFFFFFFFFL;
            int n = startWordIndex;
            this.words[n] = this.words[n] & (src.words[startWordIndex] | invFirstWordMask);
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                int n2 = i;
                this.words[n2] = this.words[n2] & src.words[i];
            }
            int n3 = endWordIndex;
            this.words[n3] = this.words[n3] & (src.words[endWordIndex] | invLastWordMask);
        }
    }

    private static int wordIndex(int index) {
        return index >> 6;
    }

    private static int bitIndex(int index) {
        return index & 0x3F;
    }

    public void fill(boolean value) {
        Arrays.fill(this.words, value ? -1L : 0L);
    }

    public void unset() {
        this.fill(false);
    }

    public void set() {
        this.fill(true);
    }

    public int count() {
        int sum = 0;
        for (long word : this.words) {
            sum += Long.bitCount(word);
        }
        return sum;
    }

    public int capacity() {
        return this.count;
    }

    public boolean getAndSet(int index) {
        int wordIndex = BitArray.wordIndex(index);
        long bit = 1L << BitArray.bitIndex(index);
        long word = this.words[wordIndex];
        this.words[wordIndex] = word | bit;
        return (word & bit) != 0L;
    }

    public boolean getAndUnset(int index) {
        int wordIndex = BitArray.wordIndex(index);
        long bit = 1L << BitArray.bitIndex(index);
        long word = this.words[wordIndex];
        this.words[wordIndex] = word & (bit ^ 0xFFFFFFFFFFFFFFFFL);
        return (word & bit) != 0L;
    }

    public int nextSetBit(int fromIndex) {
        int u = BitArray.wordIndex(fromIndex);
        if (u >= this.words.length) {
            return -1;
        }
        long word = this.words[u] & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.words.length) {
                return -1;
            }
            word = this.words[u];
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    public String toBitString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.count; ++i) {
            sb.append(this.get(i) ? (char)'1' : '0');
        }
        return sb.toString();
    }
}

