/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;

public abstract class FluidStorageProvider<T extends Accessor<?>>
implements IComponentProvider<T>,
StreamServerDataProvider<T, Map.Entry<class_2960, List<ViewGroup<FluidView.Data>>>> {
    private static final class_9139<class_9129, Map.Entry<class_2960, List<ViewGroup<FluidView.Data>>>> STREAM_CODEC = ViewGroup.listCodec(FluidView.Data.STREAM_CODEC);

    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.UNIVERSAL_FLUID_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, T accessor, IPluginConfig config) {
        if (!accessor.showDetails() && config.get(JadeIds.UNIVERSAL_FLUID_STORAGE_DETAILED)) {
            return;
        }
        List groups = ClientProxy.mapToClientGroups(accessor, JadeIds.UNIVERSAL_FLUID_STORAGE, STREAM_CODEC, WailaClientRegistration.instance().fluidStorageProviders::get, tooltip);
        if (groups == null || groups.isEmpty()) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        boolean renderGroup = groups.size() > 1 || groups.getFirst().shouldRenderGroup();
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            if (renderGroup) {
                group.renderHeader((ITooltip)theTooltip);
            }
            for (FluidView view : group.views) {
                Object text = view.overrideText != null ? view.overrideText : (view.fluidName == null ? class_2561.method_43470((String)view.current) : (accessor.showDetails() ? class_2561.method_43469((String)"jade.fluid2", (Object[])new Object[]{IDisplayHelper.get().stripColor(view.fluidName).method_27692(class_124.field_1068), class_2561.method_43470((String)view.current).method_27692(class_124.field_1068), view.max}).method_27692(class_124.field_1080) : class_2561.method_43469((String)"jade.fluid", (Object[])new Object[]{IDisplayHelper.get().stripColor(view.fluidName), view.current})));
                ProgressStyle progressStyle = helper.progressStyle().overlay(view.overlay);
                theTooltip.add(helper.progress(view.ratio, (class_2561)text, progressStyle, BoxStyle.getNestedBox(), true));
            }
        });
    }

    @Override
    @Nullable
    public Map.Entry<class_2960, List<ViewGroup<FluidView.Data>>> streamData(T accessor) {
        return CommonProxy.getServerExtensionData(accessor, WailaCommonRegistration.instance().fluidStorageProviders);
    }

    @Override
    public class_9139<class_9129, Map.Entry<class_2960, List<ViewGroup<FluidView.Data>>>> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public boolean shouldRequestData(T accessor) {
        if (!accessor.showDetails() && IWailaConfig.get().plugin().get(JadeIds.UNIVERSAL_FLUID_STORAGE_DETAILED)) {
            return false;
        }
        return WailaCommonRegistration.instance().fluidStorageProviders.hitsAny((Accessor<?>)accessor, (BiPredicate<IServerExtensionProvider<FluidView.Data>, Accessor<?>>)((BiPredicate<IServerExtensionProvider, Accessor>)IServerExtensionProvider::shouldRequestData));
    }

    public static class ForBlock
    extends FluidStorageProvider<BlockAccessor> {
        private static final ForBlock INSTANCE = new ForBlock();
    }

    public static class ForEntity
    extends FluidStorageProvider<EntityAccessor> {
        private static final ForEntity INSTANCE = new ForEntity();
    }

    public static enum Extension implements IServerExtensionProvider<FluidView.Data>,
    IClientExtensionProvider<FluidView.Data, FluidView>
    {
        INSTANCE;


        @Override
        public class_2960 getUid() {
            return JadeIds.UNIVERSAL_FLUID_STORAGE_DEFAULT;
        }

        @Override
        public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<FluidView.Data>> groups) {
            return ClientViewGroup.map(groups, FluidView::readDefault, null);
        }

        @Override
        @Nullable
        public List<ViewGroup<FluidView.Data>> getGroups(Accessor<?> accessor) {
            return CommonProxy.wrapFluidStorage(accessor);
        }

        @Override
        public boolean shouldRequestData(Accessor<?> accessor) {
            return CommonProxy.hasDefaultFluidStorage(accessor);
        }

        @Override
        public int getDefaultPriority() {
            return 9999;
        }
    }
}

