/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.vanilla.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.mc.common.gui.NativeContext;
import org.anti_ad.mc.common.math2d.Rect2dKt;
import org.anti_ad.mc.common.math2d.Rectangle;
import org.anti_ad.mc.common.vanilla.render.glue.RectKt;
import org.anti_ad.mc.common.vanilla.render.glue.ScreenKt;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fStack;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\u001a\u0019\u0010\u0002\u001a\u00060\u0000j\u0002`\u0001*\u00060\u0000j\u0002`\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0019\u0010\u0004\u001a\u00060\u0000j\u0002`\u0001*\u00060\u0000j\u0002`\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0003\u001a\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0015\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000b\u001a1\u0010\u0010\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u001d\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u001f\u0010\u0014\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013\u001a\u0015\u0010\u0015\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0015\u0010\u000b\u001a\u001f\u0010\u0016\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0013\u001a\r\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0017\u0010\u0007\u001a\r\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0018\u0010\u0007\u001a\u000f\u0010\u0019\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0007\u001a\u000f\u0010\u001a\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0007\u001a\u0017\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e\"\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\""}, d2={"Lorg/joml/Matrix4fStack;", "Lorg/anti_ad/mc/common/vanilla/alias/Matrix4fStack;", "push", "(Lorg/joml/Matrix4fStack;)Lorg/joml/Matrix4fStack;", "pop", "", "rStandardGlState", "()V", "Lorg/anti_ad/mc/common/gui/NativeContext;", "context", "rClearDepth", "(Lorg/anti_ad/mc/common/gui/NativeContext;)V", "Lorg/anti_ad/mc/common/math2d/Rectangle;", "bounds", "Lkotlin/Function0;", "block", "rDepthMask", "(Lorg/anti_ad/mc/common/gui/NativeContext;Lorg/anti_ad/mc/common/math2d/Rectangle;Lkotlin/jvm/functions/Function0;)V", "rCreateDepthMask", "(Lorg/anti_ad/mc/common/gui/NativeContext;Lorg/anti_ad/mc/common/math2d/Rectangle;)V", "rCreateDepthMaskNoCheck", "rRemoveDepthMask", "rOverwriteDepth", "rDisableDepth", "rEnableDepth", "rEnableBlend", "gEnableDepthTest", "", "value", "gDepthFunc", "(I)V", "", "depthBounds", "Ljava/util/List;", "libIPN"})
public final class GLKt {
    @NotNull
    private static final List<Rectangle> depthBounds = new ArrayList();

    @NotNull
    public static final Matrix4fStack push(@NotNull Matrix4fStack $this$push) {
        Intrinsics.checkNotNullParameter((Object)$this$push, (String)"<this>");
        Matrix4fStack matrix4fStack = $this$push.pushMatrix();
        Intrinsics.checkNotNullExpressionValue((Object)matrix4fStack, (String)"pushMatrix(...)");
        return matrix4fStack;
    }

    @NotNull
    public static final Matrix4fStack pop(@NotNull Matrix4fStack $this$pop) {
        Intrinsics.checkNotNullParameter((Object)$this$pop, (String)"<this>");
        Matrix4fStack matrix4fStack = $this$pop.popMatrix();
        Intrinsics.checkNotNullExpressionValue((Object)matrix4fStack, (String)"popMatrix(...)");
        return matrix4fStack;
    }

    public static final void rStandardGlState() {
        GLKt.rEnableBlend();
        GLKt.gEnableDepthTest();
        RenderSystem.depthMask((boolean)true);
    }

    public static final void rClearDepth(@NotNull NativeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        GLKt.gEnableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.clear((int)256);
        GLKt.rOverwriteDepth(context, ScreenKt.getRScreenBounds());
        depthBounds.clear();
    }

    public static final void rDepthMask(@NotNull NativeContext context, @NotNull Rectangle bounds, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$rDepthMask = false;
        GLKt.rCreateDepthMask(context, bounds);
        block.invoke();
        GLKt.rRemoveDepthMask(context);
    }

    public static final void rCreateDepthMask(@NotNull NativeContext context, @NotNull Rectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        GLKt.rStandardGlState();
        if (depthBounds.isEmpty()) {
            GLKt.rCreateDepthMaskNoCheck(context, bounds);
        } else {
            GLKt.rCreateDepthMaskNoCheck(context, Rect2dKt.intersect((Rectangle)CollectionsKt.last(depthBounds), bounds));
        }
    }

    private static final void rCreateDepthMaskNoCheck(NativeContext context, Rectangle bounds) {
        depthBounds.add(bounds);
        Matrix4fStack a = RenderSystem.getModelViewStack();
        Intrinsics.checkNotNull((Object)a);
        GLKt.push(a);
        a.translate(0.0f, 0.0f, -400.0f);
        GLKt.rOverwriteDepth(context, bounds);
    }

    public static final void rRemoveDepthMask(@NotNull NativeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Matrix4fStack a = RenderSystem.getModelViewStack();
        Intrinsics.checkNotNull((Object)a);
        GLKt.pop(a);
        Rectangle rectangle = depthBounds.removeLast();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"removeLast(...)");
        GLKt.rOverwriteDepth(context, rectangle);
    }

    private static final void rOverwriteDepth(NativeContext context, Rectangle bounds) {
        GLKt.gDepthFunc(519);
        RectKt.rFillRect(context, bounds, 0);
        GLKt.gDepthFunc(515);
    }

    public static final void rDisableDepth() {
        GLKt.gDepthFunc(519);
        RenderSystem.depthMask((boolean)false);
    }

    public static final void rEnableDepth() {
        RenderSystem.depthMask((boolean)true);
        GLKt.gDepthFunc(515);
    }

    private static final void rEnableBlend() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static final void gEnableDepthTest() {
        RenderSystem.enableDepthTest();
    }

    private static final void gDepthFunc(int value) {
        RenderSystem.depthFunc((int)value);
    }
}

