/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.block.redstone;

import net.caffeinemc.mods.lithium.common.util.DirectionConstants;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_9906;

public class RedstoneWirePowerCalculations {
    private static final int MIN = 0;
    private static final int MAX = 15;
    private static final int MAX_WIRE = 14;

    public static int getNeighborBlockSignal(class_2248 wireBlock, class_9906 evaluator, class_1937 level, class_2338 pos) {
        return RedstoneWirePowerCalculations.getNeighborSignal(wireBlock, evaluator, level, pos, false, true);
    }

    public static int getNeighborWireSignal(class_2248 wireBlock, class_9906 evaluator, class_1937 level, class_2338 pos) {
        return RedstoneWirePowerCalculations.getNeighborSignal(wireBlock, evaluator, level, pos, true, false);
    }

    public static int getNeighborSignal(class_2248 wireBlock, class_9906 evaluator, class_1937 level, class_2338 pos, boolean ignoreNonWires, boolean ignoreWires) {
        int signal = 0;
        class_2818 chunk = level.method_8500(pos);
        if (!ignoreNonWires) {
            for (class_2350 dir : DirectionConstants.VERTICAL) {
                class_2338 side = pos.method_10093(dir);
                class_2680 neighbor = chunk.method_8320(side);
                if (neighbor.method_26215() || neighbor.method_27852(wireBlock) || (signal = Math.max(signal, RedstoneWirePowerCalculations.getSignalFromVertical(level, side, neighbor, dir, wireBlock))) < 15) continue;
                return 15;
            }
        }
        boolean checkWiresAbove = false;
        if (!ignoreWires) {
            class_2338 above = pos.method_10084();
            checkWiresAbove = !chunk.method_8320(above).method_26212((class_1922)level, above);
        }
        for (class_2350 dir : DirectionConstants.HORIZONTAL) {
            if ((signal = Math.max(signal, RedstoneWirePowerCalculations.getSignalFromSide(level, pos.method_10093(dir), dir, checkWiresAbove, ignoreNonWires, ignoreWires, wireBlock, evaluator))) < 15) continue;
            return 15;
        }
        return signal;
    }

    private static int getSignalFromVertical(class_1937 level, class_2338 pos, class_2680 state, class_2350 toDir, class_2248 wireBlock) {
        int signal = state.method_26195((class_1922)level, pos, toDir);
        if (signal >= 15) {
            return 15;
        }
        if (state.method_26212((class_1922)level, pos)) {
            return Math.max(signal, RedstoneWirePowerCalculations.getDirectSignalTo(level, pos, toDir.method_10153(), wireBlock));
        }
        return signal;
    }

    private static int getSignalFromSide(class_1937 level, class_2338 pos, class_2350 toDir, boolean checkWiresAbove, boolean ignoreNonWires, boolean ignoreWires, class_2248 wireBlock, class_9906 evaluator) {
        class_2338 below;
        class_2680 belowState;
        class_2818 chunk = level.method_8500(pos);
        class_2680 state = chunk.method_8320(pos);
        if (state.method_27852(wireBlock)) {
            return !ignoreWires ? evaluator.method_61839(pos, state) - 1 : 0;
        }
        int signal = 0;
        if (!ignoreNonWires && (signal = state.method_26195((class_1922)level, pos, toDir)) >= 15) {
            return 15;
        }
        if (state.method_26212((class_1922)level, pos)) {
            class_2338 above;
            class_2680 aboveState;
            if (!ignoreNonWires && (signal = Math.max(signal, RedstoneWirePowerCalculations.getDirectSignalTo(level, pos, toDir.method_10153(), wireBlock))) >= 15) {
                return 15;
            }
            if (!ignoreWires && checkWiresAbove && signal < 14 && (aboveState = chunk.method_8320(above = pos.method_10084())).method_27852(wireBlock)) {
                signal = Math.max(signal, evaluator.method_61839(above, aboveState) - 1);
            }
        } else if (!ignoreWires && signal < 14 && (belowState = chunk.method_8320(below = pos.method_10074())).method_27852(wireBlock)) {
            signal = Math.max(signal, evaluator.method_61839(below, belowState) - 1);
        }
        return signal;
    }

    private static int getDirectSignalTo(class_1937 level, class_2338 pos, class_2350 ignore, class_2248 wireBlock) {
        int signal = 0;
        for (class_2350 dir : DirectionConstants.ALL) {
            class_2338 side;
            class_2680 neighbor;
            if (dir == ignore || (neighbor = level.method_8320(side = pos.method_10093(dir))).method_26215() || neighbor.method_27852(wireBlock) || (signal = Math.max(signal, neighbor.method_26203((class_1922)level, side, dir))) < 15) continue;
            return 15;
        }
        return signal;
    }
}

